/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.util.Integers;

public class S2K
extends BCPGObject {
    private static final int EXPBIAS = 6;
    public static final int SIMPLE = 0;
    public static final int SALTED = 1;
    public static final int SALTED_AND_ITERATED = 3;
    public static final int ARGON_2 = 4;
    public static final int GNU_DUMMY_S2K = 101;
    public static final int GNU_PROTECTION_MODE_NO_PRIVATE_KEY = 1;
    public static final int GNU_PROTECTION_MODE_DIVERT_TO_CARD = 2;
    public static final int GNU_PROTECTION_MODE_INTERNAL = 3;
    int type;
    int algorithm;
    byte[] iv;
    int itCount = -1;
    int passes = -1;
    int protectionMode = -1;
    int parallelism;
    int memorySizeExponent;

    S2K(InputStream in) throws IOException {
        DataInputStream dIn = new DataInputStream(in);
        this.type = dIn.read();
        switch (this.type) {
            case 0: {
                this.algorithm = dIn.read();
                break;
            }
            case 1: {
                this.algorithm = dIn.read();
                this.iv = new byte[8];
                dIn.readFully(this.iv, 0, this.iv.length);
                break;
            }
            case 3: {
                this.algorithm = dIn.read();
                this.iv = new byte[8];
                dIn.readFully(this.iv, 0, this.iv.length);
                this.itCount = dIn.read();
                break;
            }
            case 4: {
                this.iv = new byte[16];
                dIn.readFully(this.iv);
                this.passes = dIn.read();
                this.parallelism = dIn.read();
                this.memorySizeExponent = dIn.read();
                break;
            }
            case 101: {
                this.algorithm = dIn.read();
                dIn.read();
                dIn.read();
                dIn.read();
                this.protectionMode = dIn.read();
                break;
            }
            default: {
                throw new UnsupportedPacketVersionException("Invalid S2K type: " + this.type);
            }
        }
    }

    public S2K(int algorithm) {
        this.type = 0;
        this.algorithm = algorithm;
    }

    public S2K(int algorithm, byte[] iv) {
        this.type = 1;
        this.algorithm = algorithm;
        this.iv = iv;
    }

    public S2K(int algorithm, byte[] iv, int itCount) {
        this.type = 3;
        this.algorithm = algorithm;
        this.iv = iv;
        if (itCount >= 256 && itCount <= 65536) {
            throw new IllegalArgumentException("invalid itCount");
        }
        this.itCount = itCount;
    }

    public S2K(Argon2Params argon2Params) {
        this.type = 4;
        this.iv = argon2Params.getSalt();
        this.passes = argon2Params.getPasses();
        this.parallelism = argon2Params.getParallelism();
        this.memorySizeExponent = argon2Params.getMemSizeExp();
    }

    public S2K(GNUDummyParams gnuDummyParams) {
        this.type = 101;
        this.protectionMode = gnuDummyParams.getProtectionMode();
    }

    public static S2K simpleS2K(int algorithm) {
        return new S2K(algorithm);
    }

    public static S2K saltedS2K(int algorithm, byte[] salt) {
        return new S2K(algorithm, salt);
    }

    public static S2K saltedAndIteratedS2K(int algorithm, byte[] salt, int iterationCount) {
        return new S2K(algorithm, salt, iterationCount);
    }

    public static S2K argon2S2K(Argon2Params parameters) {
        return new S2K(parameters);
    }

    public static S2K gnuDummyS2K(GNUDummyParams parameters) {
        return new S2K(parameters);
    }

    public int getType() {
        return this.type;
    }

    public int getHashAlgorithm() {
        return this.algorithm;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public long getIterationCount() {
        if (this.itCount >= 256) {
            return this.itCount;
        }
        return 16 + (this.itCount & 0xF) << (this.itCount >> 4) + 6;
    }

    public int getPasses() {
        return this.passes;
    }

    public int getProtectionMode() {
        return this.protectionMode;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMemorySizeExponent() {
        return this.memorySizeExponent;
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.write(this.type);
        switch (this.type) {
            case 0: {
                out.write(this.algorithm);
                break;
            }
            case 1: {
                out.write(this.algorithm);
                out.write(this.iv);
                break;
            }
            case 3: {
                out.write(this.algorithm);
                out.write(this.iv);
                this.writeOneOctetOrThrow(out, this.itCount, "Iteration count");
                break;
            }
            case 4: {
                out.write(this.iv);
                this.writeOneOctetOrThrow(out, this.passes, "Passes");
                this.writeOneOctetOrThrow(out, this.parallelism, "Parallelism");
                this.writeOneOctetOrThrow(out, this.memorySizeExponent, "Memory size exponent");
                break;
            }
            case 101: {
                out.write(this.algorithm);
                out.write(71);
                out.write(78);
                out.write(85);
                out.write(this.protectionMode);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown S2K type " + this.type);
            }
        }
    }

    private void writeOneOctetOrThrow(BCPGOutputStream out, int val, String valName) throws IOException {
        if ((val & 0xFFFFFF00) != 0) {
            throw new IllegalStateException(valName + " not encodable");
        }
        out.write(val);
    }

    public static class GNUDummyParams {
        private final int protectionMode;

        private GNUDummyParams(int protectionMode) {
            this.protectionMode = protectionMode;
        }

        public static GNUDummyParams noPrivateKey() {
            return new GNUDummyParams(1);
        }

        public static GNUDummyParams divertToCard() {
            return new GNUDummyParams(2);
        }

        public static GNUDummyParams internal() {
            return new GNUDummyParams(3);
        }

        public int getProtectionMode() {
            return this.protectionMode;
        }
    }

    public static class Argon2Params {
        private final byte[] salt;
        private final int passes;
        private final int parallelism;
        private final int memSizeExp;

        public Argon2Params() {
            this(CryptoServicesRegistrar.getSecureRandom());
        }

        public Argon2Params(SecureRandom secureRandom) {
            this(1, 4, 21, secureRandom);
        }

        public Argon2Params(int passes, int parallelism, int memSizeExp, SecureRandom secureRandom) {
            this(Argon2Params.mineSalt(secureRandom), passes, parallelism, memSizeExp);
        }

        public Argon2Params(byte[] salt, int passes, int parallelism, int memSizeExp) {
            if (salt.length != 16) {
                throw new IllegalArgumentException("Argon2 uses 16 bytes of salt");
            }
            if (passes < 1 | passes > 255) {
                throw new IllegalArgumentException("Passes MUST be an integer value from 1 to 255.");
            }
            if (parallelism < 1 || parallelism > 255) {
                throw new IllegalArgumentException("Parallelism MUST be an integer value from 1 to 255.");
            }
            int minExp = 35 - Integers.numberOfLeadingZeros((int)(parallelism - 1));
            int maxExp = 30;
            if (memSizeExp < minExp || memSizeExp > maxExp) {
                throw new IllegalArgumentException("Memory size exponent MUST be an integer value from 3 + bitlen(parallelism - 1) to 30.");
            }
            this.salt = salt;
            this.passes = passes;
            this.parallelism = parallelism;
            this.memSizeExp = memSizeExp;
        }

        public static Argon2Params universallyRecommendedParameters() {
            return new Argon2Params(1, 4, 21, CryptoServicesRegistrar.getSecureRandom());
        }

        public static Argon2Params memoryConstrainedParameters() {
            return new Argon2Params(3, 4, 16, CryptoServicesRegistrar.getSecureRandom());
        }

        private static byte[] mineSalt(SecureRandom secureRandom) {
            byte[] salt = new byte[16];
            secureRandom.nextBytes(salt);
            return salt;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public int getPasses() {
            return this.passes;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public int getMemSizeExp() {
            return this.memSizeExp;
        }
    }
}

