/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.util.Locale;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

public class FingerprintUtil {
    public static long keyIdFromFingerprint(int keyVersion, byte[] fingerprint) {
        switch (keyVersion) {
            case 4: {
                return FingerprintUtil.keyIdFromV4Fingerprint(fingerprint);
            }
            case 5: {
                return FingerprintUtil.keyIdFromLibrePgpFingerprint(fingerprint);
            }
            case 6: {
                return FingerprintUtil.keyIdFromV6Fingerprint(fingerprint);
            }
        }
        return 0L;
    }

    public static long keyIdFromV6Fingerprint(byte[] v6Fingerprint) {
        return FingerprintUtil.longFromLeftMostBytes(v6Fingerprint);
    }

    public static long keyIdFromLibrePgpFingerprint(byte[] v5Fingerprint) {
        return FingerprintUtil.longFromLeftMostBytes(v5Fingerprint);
    }

    public static long keyIdFromV4Fingerprint(byte[] v4Fingerprint) {
        return FingerprintUtil.longFromRightMostBytes(v4Fingerprint);
    }

    public static long longFromLeftMostBytes(byte[] bytes) {
        return FingerprintUtil.readKeyID(bytes);
    }

    public static long longFromRightMostBytes(byte[] bytes) {
        return FingerprintUtil.readKeyID(bytes, bytes.length - 8);
    }

    public static long readKeyID(byte[] bytes) {
        return FingerprintUtil.readKeyID(bytes, 0);
    }

    public static long readKeyID(byte[] bytes, int offset) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("Byte array MUST contain at least 8 bytes");
        }
        return Pack.bigEndianToLong((byte[])bytes, (int)offset);
    }

    public static void writeKeyID(long keyID, byte[] bytes, int offset) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough space to write key-ID to byte array.");
        }
        Pack.longToBigEndian((long)keyID, (byte[])bytes, (int)offset);
    }

    public static void writeKeyID(long keyID, byte[] bytes) {
        FingerprintUtil.writeKeyID(keyID, bytes, 0);
    }

    public static String prettifyFingerprint(byte[] fingerprint) {
        char[] hex = Hex.toHexString((byte[])fingerprint).toUpperCase(Locale.getDefault()).toCharArray();
        StringBuffer sb = new StringBuffer();
        switch (hex.length) {
            case 32: {
                int i;
                for (i = 0; i < 4; ++i) {
                    sb.append(hex, i * 4, 4).append(' ');
                }
                sb.append(' ');
                for (i = 4; i < 7; ++i) {
                    sb.append(hex, i * 4, 4).append(' ');
                }
                sb.append(hex, 28, 4);
                return sb.toString();
            }
            case 40: {
                int i;
                for (i = 0; i <= 4; ++i) {
                    sb.append(hex, i * 4, 4).append(' ');
                }
                sb.append(' ');
                for (i = 5; i <= 8; ++i) {
                    sb.append(hex, i * 4, 4).append(' ');
                }
                sb.append(hex, 36, 4);
                return sb.toString();
            }
            case 64: {
                int i;
                for (i = 0; i < 4; ++i) {
                    sb.append(hex, i * 8, 8).append(' ');
                }
                sb.append(' ');
                for (i = 4; i < 7; ++i) {
                    sb.append(hex, i * 8, 8).append(' ');
                }
                sb.append(hex, 56, 8);
                return sb.toString();
            }
        }
        return new String(hex);
    }
}

