/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.BasicRawAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.AbstractPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;

public class BcPublicKeyDataDecryptorFactory
extends AbstractPublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pgpPrivKey) {
        this.pgpPrivKey = pgpPrivKey;
    }

    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData, int pkeskVersion) throws PGPException {
        try {
            AsymmetricKeyParameter privKey = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (keyAlgorithm == 25) {
                return this.getSessionData(secKeyData[0], privKey, 32, 8, 7, (RawAgreement)new X25519Agreement(), "X25519", this.containsSKAlg(pkeskVersion), new PublicKeyParametersOperation(){

                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X25519PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 26) {
                return this.getSessionData(secKeyData[0], privKey, 56, 10, 9, (RawAgreement)new X448Agreement(), "X448", this.containsSKAlg(pkeskVersion), new PublicKeyParametersOperation(){

                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X448PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 18) {
                return this.recoverECDHSessionData(secKeyData, privKey);
            }
            if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                return this.recoverRSASessionData(keyAlgorithm, secKeyData, privKey);
            }
            return this.recoverElgamalSessionData(keyAlgorithm, secKeyData, privKey);
        }
        catch (IOException e) {
            throw new PGPException("exception creating user keying material: " + e.getMessage(), e);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception decrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private byte[] recoverElgamalSessionData(int keyAlgorithm, byte[][] secKeyData, AsymmetricKeyParameter privKey) throws PGPException, InvalidCipherTextException {
        BufferedAsymmetricBlockCipher c1 = BcPublicKeyDataDecryptorFactory.getBufferedAsymmetricBlockCipher(keyAlgorithm, privKey);
        ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)privKey;
        int size = (parms.getParameters().getP().bitLength() + 7) / 8;
        byte[] tmp = new byte[size];
        byte[] bi = secKeyData[0];
        this.processEncodedMpi(c1, size, tmp, bi);
        bi = secKeyData[1];
        Arrays.fill((byte[])tmp, (byte)0);
        this.processEncodedMpi(c1, size, tmp, bi);
        return c1.doFinal();
    }

    private byte[] recoverRSASessionData(int keyAlgorithm, byte[][] secKeyData, AsymmetricKeyParameter privKey) throws PGPException, InvalidCipherTextException {
        BufferedAsymmetricBlockCipher c1 = BcPublicKeyDataDecryptorFactory.getBufferedAsymmetricBlockCipher(keyAlgorithm, privKey);
        byte[] bi = secKeyData[0];
        c1.processBytes(bi, 2, bi.length - 2);
        return c1.doFinal();
    }

    private static BufferedAsymmetricBlockCipher getBufferedAsymmetricBlockCipher(int keyAlgorithm, AsymmetricKeyParameter privKey) throws PGPException {
        BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(BcImplProvider.createPublicKeyCipher(keyAlgorithm));
        c1.init(false, (CipherParameters)privKey);
        return c1;
    }

    private void processEncodedMpi(BufferedAsymmetricBlockCipher c1, int size, byte[] tmp, byte[] bi) {
        if (bi.length - 2 > size) {
            c1.processBytes(bi, 3, bi.length - 3);
        } else {
            System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
            c1.processBytes(tmp, 0, tmp.length);
        }
    }

    private byte[] recoverECDHSessionData(byte[][] secKeyData, AsymmetricKeyParameter privKey) throws PGPException, IOException, InvalidCipherTextException {
        byte[] secret;
        byte[] enc = secKeyData[0];
        int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
        BcPublicKeyDataDecryptorFactory.checkRange(2 + pLen + 1, enc);
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 2, pEnc, 0, pLen);
        int keyLen = enc[pLen + 2] & 0xFF;
        BcPublicKeyDataDecryptorFactory.checkRange(2 + pLen + 1 + keyLen, enc);
        byte[] keyEnc = new byte[keyLen];
        System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
        ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
        if (ecPubKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
            if (pEnc.length != 33 || 64 != pEnc[0]) {
                throw new IllegalArgumentException("Invalid Curve25519 public key");
            }
            secret = BcUtil.getSecret((RawAgreement)new X25519Agreement(), privKey, (AsymmetricKeyParameter)new X25519PublicKeyParameters(pEnc, 1));
        } else if (ecPubKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
            if (pEnc.length != 57 || 64 != pEnc[0]) {
                throw new IllegalArgumentException("Invalid Curve448 public key");
            }
            secret = BcUtil.getSecret((RawAgreement)new X448Agreement(), privKey, (AsymmetricKeyParameter)new X448PublicKeyParameters(pEnc, 1));
        } else {
            ECDomainParameters ecParameters = ((ECPrivateKeyParameters)privKey).getParameters();
            ECPublicKeyParameters ephPub = new ECPublicKeyParameters(ecParameters.getCurve().decodePoint(pEnc), ecParameters);
            secret = BcUtil.getSecret((RawAgreement)new BasicRawAgreement((BasicAgreement)new ECDHBasicAgreement()), privKey, (AsymmetricKeyParameter)ephPub);
        }
        byte hashAlgorithm = ecPubKey.getHashAlgorithm();
        byte symmetricKeyAlgorithm = ecPubKey.getSymmetricKeyAlgorithm();
        byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
        RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(hashAlgorithm), symmetricKeyAlgorithm);
        KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
        return PGPPad.unpadSessionData(BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, symmetricKeyAlgorithm, key));
    }

    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
    }

    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(seipd, sessionKey);
    }

    private byte[] getSessionData(byte[] enc, AsymmetricKeyParameter privKey, int pLen, int hashAlgorithm, int symmetricKeyAlgorithm, RawAgreement agreement, String algorithmName, boolean includesSesKeyAlg, PublicKeyParametersOperation pkp) throws PGPException, InvalidCipherTextException {
        byte[] ephemeralKey = Arrays.copyOf((byte[])enc, (int)pLen);
        int size = enc[pLen] & 0xFF;
        BcPublicKeyDataDecryptorFactory.checkRange(pLen + 1 + size, enc);
        int sesKeyLen = size - (includesSesKeyAlg ? 1 : 0);
        int sesKeyOff = pLen + 1 + (includesSesKeyAlg ? 1 : 0);
        byte[] keyEnc = Arrays.copyOfRange((byte[])enc, (int)sesKeyOff, (int)(sesKeyOff + sesKeyLen));
        byte[] secret = BcUtil.getSecret(agreement, privKey, pkp.getPublicKeyParameters(ephemeralKey, 0));
        byte[] hkdfOut = RFC6637KDFCalculator.createKey(hashAlgorithm, symmetricKeyAlgorithm, Arrays.concatenate((byte[])ephemeralKey, (byte[])this.pgpPrivKey.getPublicKeyPacket().getKey().getEncoded(), (byte[])secret), "OpenPGP " + algorithmName);
        return BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, 7, new KeyParameter(hkdfOut));
    }

    private static byte[] unwrapSessionData(byte[] keyEnc, int symmetricKeyAlgorithm, KeyParameter key) throws PGPException, InvalidCipherTextException {
        Wrapper c = BcImplProvider.createWrapper(symmetricKeyAlgorithm);
        c.init(false, (CipherParameters)key);
        return c.unwrap(keyEnc, 0, keyEnc.length);
    }

    private static interface PublicKeyParametersOperation {
        public AsymmetricKeyParameter getPublicKeyParameters(byte[] var1, int var2);
    }
}

