/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.AEADUtil;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private byte[] salt = new byte[32];
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = true;
    private SessionKeyExtractionCallback sessionKeyExtractionCallback = null;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder) {
        this(encryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder, boolean oldFormat) {
        this.dataEncryptorBuilder = encryptorBuilder;
        this.useOldFormat = oldFormat;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        this.rand.nextBytes(this.salt);
    }

    public void setForceSessionKey(boolean forceSessionKey) {
        this.forceSessionKey = forceSessionKey;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator method) {
        this.methods.add(method);
    }

    public void setSessionKeyExtractionCallback(SessionKeyExtractionCallback callback) {
        this.sessionKeyExtractionCallback = callback;
    }

    private OutputStream open(OutputStream out, long length, byte[] buffer) throws IOException, PGPException, IllegalStateException {
        byte[] messageKey;
        byte[] sessionKey;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        this.pOut = new BCPGOutputStream(out, !this.useOldFormat);
        Object sessionInfo = null;
        boolean directS2K = !this.forceSessionKey && this.methods.size() == 1 && this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
        boolean isV5StyleAEAD = this.dataEncryptorBuilder.isV5StyleAEAD();
        if (this.dataEncryptorBuilder.getAeadAlgorithm() != -1 && !isV5StyleAEAD) {
            sessionKey = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            byte[] info = SymmetricEncIntegrityPacket.createAAData(2, this.defAlgorithm, this.dataEncryptorBuilder.getAeadAlgorithm(), this.dataEncryptorBuilder.getChunkSize());
            messageKey = AEADUtil.deriveMessageKeyAndIv(this.dataEncryptorBuilder.getAeadAlgorithm(), this.defAlgorithm, sessionKey, this.salt, info);
        } else {
            messageKey = directS2K ? (sessionKey = ((PBEKeyEncryptionMethodGenerator)this.methods.get(0)).getKey(this.defAlgorithm)) : (sessionKey = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand));
        }
        if (this.sessionKeyExtractionCallback != null) {
            this.sessionKeyExtractionCallback.extractSessionKey(new PGPSessionKey(this.defAlgorithm, sessionKey));
        }
        PGPDataEncryptor dataEncryptor = this.dataEncryptorBuilder.build(messageKey);
        this.digestCalc = dataEncryptor.getIntegrityCalculator();
        for (int i = 0; i < this.methods.size(); ++i) {
            PGPKeyEncryptionMethodGenerator method = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
            this.pOut.writePacket(method.generate(this.dataEncryptorBuilder, sessionKey));
        }
        try {
            if (dataEncryptor instanceof PGPAEADDataEncryptor) {
                long ivOrSaltLen;
                InputStreamPacket encOut;
                PGPAEADDataEncryptor aeadDataEncryptor = (PGPAEADDataEncryptor)dataEncryptor;
                if (isV5StyleAEAD) {
                    byte[] iv = aeadDataEncryptor.getIV();
                    encOut = new AEADEncDataPacket(this.defAlgorithm, aeadDataEncryptor.getAEADAlgorithm(), aeadDataEncryptor.getChunkSize(), iv);
                    ivOrSaltLen = iv.length;
                } else {
                    encOut = SymmetricEncIntegrityPacket.createVersion2Packet(this.defAlgorithm, aeadDataEncryptor.getAEADAlgorithm(), aeadDataEncryptor.getChunkSize(), this.salt);
                    ivOrSaltLen = this.salt.length;
                }
                if (buffer == null) {
                    long chunkLength = 1L << aeadDataEncryptor.getChunkSize() + 6;
                    long tagLengths = (length + chunkLength - 1L) / chunkLength * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), length + tagLengths + 4L + ivOrSaltLen);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), buffer);
                }
                this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
            } else {
                InputStreamPacket encOut;
                if (this.digestCalc != null) {
                    encOut = SymmetricEncIntegrityPacket.createVersion1Packet();
                    if (this.useOldFormat) {
                        throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                    }
                } else {
                    encOut = new SymmetricEncDataPacket();
                }
                if (buffer == null) {
                    long outLength = this.digestCalc == null ? length + (long)dataEncryptor.getBlockSize() + 2L : length + (long)dataEncryptor.getBlockSize() + 2L + 1L + 22L;
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), outLength, this.useOldFormat);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), buffer);
                }
                this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
                if (this.digestCalc != null) {
                    this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
                }
                byte[] inLineIv = new byte[dataEncryptor.getBlockSize() + 2];
                this.rand.nextBytes(inLineIv);
                inLineIv[inLineIv.length - 1] = inLineIv[inLineIv.length - 3];
                inLineIv[inLineIv.length - 2] = inLineIv[inLineIv.length - 4];
                this.genOut.write(inLineIv);
            }
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    public OutputStream open(OutputStream out, long length) throws IOException, PGPException {
        return this.open(out, length, null);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        return this.open(out, 0L, buffer);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bOut = new BCPGOutputStream(this.genOut, 19, 20L);
                bOut.flush();
                byte[] dig = this.digestCalc.getDigest();
                this.cOut.write(dig);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    public static interface SessionKeyExtractionCallback {
        public void extractSessionKey(PGPSessionKey var1);
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, byte[] buffer) throws IOException {
            super(out, header.getType(), buffer);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length, boolean useOldIfPossible) throws IOException {
            super(out, header.getType(), length, useOldIfPossible);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length) throws IOException {
            super(out, header.getType(), length);
            header.encode(this);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

