/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.mls.codec.HPKECiphertext;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class UpdatePathNode
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    byte[] encryption_key;
    List<HPKECiphertext> encrypted_path_secret;

    public byte[] getEncryptionKey() {
        return this.encryption_key;
    }

    public List<HPKECiphertext> getEncryptedPathSecret() {
        return this.encrypted_path_secret;
    }

    public UpdatePathNode(byte[] encryption_key, List<HPKECiphertext> encrypted_path_secret) {
        this.encryption_key = encryption_key;
        this.encrypted_path_secret = encrypted_path_secret;
    }

    UpdatePathNode(MLSInputStream stream) throws IOException {
        this.encryption_key = stream.readOpaque();
        this.encrypted_path_secret = new ArrayList<HPKECiphertext>();
        stream.readList(this.encrypted_path_secret, HPKECiphertext.class);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.encryption_key);
        stream.writeList(this.encrypted_path_secret);
    }
}

