/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls;

import java.util.Arrays;
import org.bouncycastle.mls.crypto.Secret;

public class KeyGeneration {
    public final int generation;
    public final byte[] key;
    public final byte[] nonce;

    public KeyGeneration(int generation, Secret key, Secret nonce) {
        this.generation = generation;
        this.key = (byte[])key.value().clone();
        this.nonce = (byte[])nonce.value().clone();
        key.consume();
        nonce.consume();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyGeneration that = (KeyGeneration)o;
        return this.generation == that.generation && Arrays.equals(this.key, that.key) && Arrays.equals(this.nonce, that.nonce);
    }

    void consume() {
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.nonce, (byte)0);
    }
}

