/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto.bc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsKdf;

public class BcMlsKdf
implements MlsKdf {
    private final HKDFBytesGenerator kdf;

    public BcMlsKdf(Digest digest) {
        this.kdf = new HKDFBytesGenerator(digest);
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int getHashLength() {
        return this.kdf.getDigest().getDigestSize();
    }

    @Override
    public byte[] extract(byte[] salt, byte[] ikm) {
        byte[] out = this.kdf.extractPRK(salt, ikm);
        this.kdf.getDigest().reset();
        return out;
    }

    @Override
    public byte[] expand(byte[] prk, byte[] info, int length) {
        byte[] okm = new byte[length];
        this.kdf.init((DerivationParameters)HKDFParameters.skipExtractParameters((byte[])prk, (byte[])info));
        this.kdf.generateBytes(okm, 0, okm.length);
        this.kdf.getDigest().reset();
        return okm;
    }

    @Override
    public byte[] expandWithLabel(byte[] secret, String label, byte[] context, int length) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.write((short)length);
        stream.writeOpaque(("MLS 1.0 " + label).getBytes(StandardCharsets.UTF_8));
        stream.writeOpaque(context);
        byte[] kdfLabel = stream.toByteArray();
        return this.expand(secret, kdfLabel, length);
    }
}

