/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto.bc;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.mls.crypto.MlsAead;
import org.bouncycastle.util.Arrays;

public class BcMlsAead
implements MlsAead {
    private final short aeadId;
    private final AEADCipher cipher;

    public BcMlsAead(short aeadId) {
        this.aeadId = aeadId;
        switch (aeadId) {
            case 1: 
            case 2: {
                this.cipher = GCMBlockCipher.newInstance((BlockCipher)AESEngine.newInstance());
                break;
            }
            case 3: {
                this.cipher = new ChaCha20Poly1305();
                break;
            }
            default: {
                this.cipher = null;
            }
        }
    }

    @Override
    public int getKeySize() {
        switch (this.aeadId) {
            case 1: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return -1;
    }

    @Override
    public int getNonceSize() {
        switch (this.aeadId) {
            case 1: 
            case 2: 
            case 3: {
                return 12;
            }
        }
        return -1;
    }

    @Override
    public byte[] open(byte[] key, byte[] nonce, byte[] aad, byte[] ct) throws InvalidCipherTextException {
        return this.crypt(false, key, nonce, aad, ct);
    }

    @Override
    public byte[] seal(byte[] key, byte[] nonce, byte[] aad, byte[] pt) throws InvalidCipherTextException {
        return this.crypt(true, key, nonce, aad, pt);
    }

    private byte[] crypt(boolean forEncryption, byte[] key, byte[] nonce, byte[] aad, byte[] input) throws InvalidCipherTextException {
        this.cipher.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
        if (aad != null) {
            this.cipher.processAADBytes(aad, 0, aad.length);
        }
        byte[] output = new byte[this.cipher.getOutputSize(input.length)];
        int len = this.cipher.processBytes(input, 0, input.length, output, 0);
        if ((len += this.cipher.doFinal(output, len)) < output.length) {
            return Arrays.copyOf((byte[])output, (int)len);
        }
        return output;
    }
}

