/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.ConfirmedTranscriptHashInput;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.FramedContentAuthData;
import org.bouncycastle.mls.codec.FramedContentTBS;
import org.bouncycastle.mls.codec.InterimTranscriptHashInput;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.SenderType;
import org.bouncycastle.mls.codec.WireFormat;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class AuthenticatedContent
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    WireFormat wireFormat;
    FramedContent content;
    FramedContentAuthData auth;

    public FramedContent getContent() {
        return this.content;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setConfirmationTag(byte[] tag) {
        this.auth.confirmation_tag = tag;
    }

    public byte[] getConfirmationTag() {
        return this.auth.confirmation_tag;
    }

    public byte[] getConfirmedTranscriptHashInput() throws IOException {
        return MLSOutputStream.encode(new ConfirmedTranscriptHashInput(this.wireFormat, this.content, this.auth.signature));
    }

    public byte[] getInterimTranscriptHashInput() throws IOException {
        return MLSOutputStream.encode(new InterimTranscriptHashInput(this.auth.confirmation_tag));
    }

    public AuthenticatedContent(WireFormat wireFormat, FramedContent content, FramedContentAuthData auth) throws Exception {
        this.wireFormat = wireFormat;
        this.content = content;
        this.auth = auth;
        if (auth.contentType == ContentType.APPLICATION) {
            if (wireFormat != WireFormat.mls_private_message) {
                throw new Exception("Unencrypted application message");
            }
            if (content.sender.senderType != SenderType.MEMBER) {
                throw new Exception("sender must be a member");
            }
        }
    }

    public static AuthenticatedContent sign(WireFormat wireFormat, FramedContent content, MlsCipherSuite suite, byte[] sigPriv, byte[] groupContext) throws Exception {
        if (wireFormat == WireFormat.mls_public_message && content.contentType == ContentType.APPLICATION) {
            throw new Exception("Application data cannot be sent as PublicMessage");
        }
        FramedContentTBS tbs = new FramedContentTBS(wireFormat, content, groupContext);
        byte[] signature = suite.signWithLabel(sigPriv, "FramedContentTBS", MLSOutputStream.encode(tbs));
        FramedContentAuthData auth = new FramedContentAuthData(content.contentType, signature, null);
        return new AuthenticatedContent(wireFormat, content, auth);
    }

    public boolean verify(MlsCipherSuite suite, byte[] sigPub, byte[] context) throws IOException {
        if (this.wireFormat == WireFormat.mls_public_message && this.content.contentType == ContentType.APPLICATION) {
            return false;
        }
        FramedContentTBS tbs = new FramedContentTBS(this.wireFormat, this.content, context);
        return suite.verifyWithLabel(sigPub, "FramedContentTBS", MLSOutputStream.encode(tbs), this.auth.signature);
    }

    public AuthenticatedContent(MLSInputStream stream) throws IOException {
        this.wireFormat = WireFormat.values()[(Short)stream.read(Short.TYPE)];
        this.content = (FramedContent)stream.read(FramedContent.class);
        this.auth = new FramedContentAuthData(stream, this.content.contentType);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.wireFormat);
        stream.write(this.content);
        stream.write(this.auth);
    }
}

