/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP384R1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP521R1Curve;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.crypto.MlsSigner;
import org.bouncycastle.util.encoders.Hex;

public class BcMlsSigner
implements MlsSigner {
    Signer signer;
    ECDomainParameters domainParams;
    int sigID;

    public BcMlsSigner(int sigID) {
        this.sigID = sigID;
        switch (sigID) {
            case 3: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA256Digest());
                SecP256R1Curve curve = new SecP256R1Curve();
                this.domainParams = new ECDomainParameters((ECCurve)curve, curve.createPoint(new BigInteger(1, Hex.decode((String)"6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296")), new BigInteger(1, Hex.decode((String)"4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5"))), curve.getOrder(), curve.getCofactor(), Hex.decode((String)"c49d360886e704936a6678e1139d26b7819f7e90"));
                break;
            }
            case 4: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA512Digest());
                SecP521R1Curve curve = new SecP521R1Curve();
                this.domainParams = new ECDomainParameters((ECCurve)curve, curve.createPoint(new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16), new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16)), curve.getOrder(), curve.getCofactor(), Hex.decode((String)"d09e8800291cb85396cc6717393284aaa0da64ba"));
                break;
            }
            case 5: {
                this.signer = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new SHA384Digest());
                SecP384R1Curve curve = new SecP384R1Curve();
                this.domainParams = new ECDomainParameters((ECCurve)curve, curve.createPoint(new BigInteger(1, Hex.decode((String)"aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7")), new BigInteger(1, Hex.decode((String)"3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f"))), curve.getOrder(), curve.getCofactor(), Hex.decode((String)"a335926aa319a27a1d00896a6773a4827acdac73"));
                break;
            }
            case 7: {
                this.signer = new Ed25519Signer();
                break;
            }
            case 8: {
                this.signer = new Ed448Signer(new byte[0]);
            }
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateSignatureKeyPair() {
        SecureRandom random = new SecureRandom();
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECKeyPairGenerator pGen = new ECKeyPairGenerator();
                ECKeyGenerationParameters genParam = new ECKeyGenerationParameters(this.domainParams, random);
                pGen.init((KeyGenerationParameters)genParam);
                return pGen.generateKeyPair();
            }
            case 8: {
                Ed448KeyPairGenerator kpg448 = new Ed448KeyPairGenerator();
                kpg448.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(random));
                return kpg448.generateKeyPair();
            }
            case 7: {
                Ed25519KeyPairGenerator kpg25519 = new Ed25519KeyPairGenerator();
                kpg25519.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(random));
                return kpg25519.generateKeyPair();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] serializePublicKey(AsymmetricKeyParameter key) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                return ((ECPublicKeyParameters)key).getQ().getEncoded(false);
            }
            case 8: {
                return ((Ed448PublicKeyParameters)key).getEncoded();
            }
            case 7: {
                return ((Ed25519PublicKeyParameters)key).getEncoded();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] serializePrivateKey(AsymmetricKeyParameter key) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                return ((ECPrivateKeyParameters)key).getD().toByteArray();
            }
            case 8: {
                return ((Ed448PrivateKeyParameters)key).getEncoded();
            }
            case 7: {
                return ((Ed25519PrivateKeyParameters)key).getEncoded();
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public AsymmetricKeyParameter deserializePublicKey(byte[] pub) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECPoint G = this.domainParams.getCurve().decodePoint(pub);
                return new ECPublicKeyParameters(G, this.domainParams);
            }
            case 7: {
                return new X25519PublicKeyParameters(pub);
            }
            case 8: {
                return new X448PublicKeyParameters(pub);
            }
        }
        throw new IllegalStateException("Unknown mode");
    }

    @Override
    public AsymmetricCipherKeyPair deserializePrivateKey(byte[] priv) {
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                BigInteger d = new BigInteger(1, priv);
                ECPrivateKeyParameters ec = new ECPrivateKeyParameters(d, this.domainParams);
                ECPoint Q = new FixedPointCombMultiplier().multiply(this.domainParams.getG(), ec.getD());
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(Q, this.domainParams), (AsymmetricKeyParameter)ec);
            }
            case 7: {
                Ed25519PrivateKeyParameters ed25519 = new Ed25519PrivateKeyParameters(priv);
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)ed25519.generatePublicKey(), (AsymmetricKeyParameter)ed25519);
            }
            case 8: {
                Ed448PrivateKeyParameters ed448 = new Ed448PrivateKeyParameters(priv);
                return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)ed448.generatePublicKey(), (AsymmetricKeyParameter)ed448);
            }
        }
        throw new IllegalStateException("invalid sig algorithm");
    }

    @Override
    public byte[] signWithLabel(byte[] priv, String label, byte[] content) throws IOException, CryptoException {
        MlsCipherSuite.GenericContent signContent = new MlsCipherSuite.GenericContent(label, content);
        byte[] signContentBytes = MLSOutputStream.encode(signContent);
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                BigInteger d = new BigInteger(1, priv);
                this.signer.init(true, (CipherParameters)new ECPrivateKeyParameters(d, this.domainParams));
                break;
            }
            case 7: {
                this.signer.init(true, (CipherParameters)new Ed25519PrivateKeyParameters(priv));
                break;
            }
            case 8: {
                this.signer.init(true, (CipherParameters)new Ed448PrivateKeyParameters(priv));
            }
        }
        this.signer.update(signContentBytes, 0, signContentBytes.length);
        return this.signer.generateSignature();
    }

    @Override
    public boolean verifyWithLabel(byte[] pub, String label, byte[] content, byte[] signature) throws IOException {
        MlsCipherSuite.GenericContent signContent = new MlsCipherSuite.GenericContent(label, content);
        byte[] signContentBytes = MLSOutputStream.encode(signContent);
        switch (this.sigID) {
            case 3: 
            case 4: 
            case 5: {
                ECPoint G = this.domainParams.getCurve().decodePoint(pub);
                this.signer.init(false, (CipherParameters)new ECPublicKeyParameters(G, this.domainParams));
                break;
            }
            case 7: {
                this.signer.init(false, (CipherParameters)new Ed25519PublicKeyParameters(pub));
                break;
            }
            case 8: {
                this.signer.init(false, (CipherParameters)new Ed448PublicKeyParameters(pub));
            }
        }
        this.signer.update(signContentBytes, 0, signContentBytes.length);
        return this.signer.verifySignature(signature);
    }
}

