/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto.bc;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.mls.crypto.MlsAead;

public class BcMlsAead
implements MlsAead {
    AEADCipher cipher;
    private final short aeadId;

    public BcMlsAead(short aeadId) {
        this.aeadId = aeadId;
        switch (aeadId) {
            case 1: 
            case 2: {
                this.cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
                break;
            }
            case 3: {
                this.cipher = new ChaCha20Poly1305();
                break;
            }
        }
    }

    @Override
    public int getKeySize() {
        switch (this.aeadId) {
            case 1: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return -1;
    }

    private int getTagSize() {
        switch (this.aeadId) {
            case 1: 
            case 2: 
            case 3: {
                return 16;
            }
        }
        return -1;
    }

    @Override
    public int getNonceSize() {
        switch (this.aeadId) {
            case 1: 
            case 2: 
            case 3: {
                return 12;
            }
        }
        return -1;
    }

    @Override
    public byte[] open(byte[] key, byte[] nonce, byte[] aad, byte[] ct) throws InvalidCipherTextException {
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce);
        this.cipher.init(false, (CipherParameters)params);
        if (aad != null) {
            this.cipher.processAADBytes(aad, 0, aad.length);
        }
        byte[] pt = new byte[this.cipher.getOutputSize(ct.length)];
        int len = this.cipher.processBytes(ct, 0, ct.length, pt, 0);
        len += this.cipher.doFinal(pt, len);
        return pt;
    }

    @Override
    public byte[] seal(byte[] key, byte[] nonce, byte[] aad, byte[] pt) throws InvalidCipherTextException {
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce);
        this.cipher.init(true, (CipherParameters)params);
        this.cipher.processAADBytes(aad, 0, aad.length);
        byte[] ct = new byte[this.cipher.getOutputSize(pt.length)];
        int len = this.cipher.processBytes(pt, 0, pt.length, ct, 0);
        this.cipher.doFinal(ct, len);
        return ct;
    }
}

