/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class Secret {
    byte[] value;
    Secret[] parents;

    public Secret(byte[] value) {
        this.value = value;
        this.parents = null;
    }

    private Secret(byte[] value, Secret[] parents) {
        this.value = value;
        this.parents = parents;
    }

    public static Secret zero(MlsCipherSuite suite) {
        return new Secret(new byte[suite.getKDF().getHashLength()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret secret = (Secret)o;
        return Arrays.equals(this.value, secret.value) && Arrays.equals(this.parents, secret.parents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public final byte[] value() {
        return this.value;
    }

    public boolean isConsumed() {
        return this.value == null && this.parents == null;
    }

    public void consume() {
        if (this.isConsumed()) {
            return;
        }
        Arrays.fill(this.value, (byte)0);
        this.value = null;
        if (this.parents != null) {
            for (Secret parent : this.parents) {
                parent.consume();
            }
            this.parents = null;
        }
    }

    public static Secret extract(MlsCipherSuite suite, Secret salt, Secret ikm) {
        byte[] prk = suite.getKDF().extract(salt.value(), ikm.value());
        return new Secret(prk, new Secret[]{salt, ikm});
    }

    public Secret expand(MlsCipherSuite suite, String label, int length) {
        byte[] labelData = label.getBytes(StandardCharsets.UTF_8);
        byte[] derivedSecret = suite.getKDF().expand(this.value, labelData, length);
        return new Secret(derivedSecret, new Secret[]{this});
    }

    public Secret expandWithLabel(MlsCipherSuite suite, String label, byte[] context, int length) throws IOException {
        KDFLabel kdfLabelStr = new KDFLabel((short)length, label, context);
        byte[] kdfLabel = MLSOutputStream.encode(kdfLabelStr);
        byte[] derivedSecret = suite.getKDF().expand(this.value, kdfLabel, length);
        return new Secret(derivedSecret, new Secret[]{this});
    }

    public Secret deriveSecret(MlsCipherSuite suite, String label) throws IOException {
        return this.expandWithLabel(suite, label, new byte[0], suite.getKDF().getHashLength());
    }

    public Secret deriveTreeSecret(MlsCipherSuite suite, String label, int generation, int length) throws IOException {
        return this.expandWithLabel(suite, label, MLSOutputStream.encode(generation), length);
    }

    public static class KDFLabel
    implements MLSOutputStream.Writable {
        public short length;
        public byte[] label;
        public byte[] context;

        KDFLabel(short length, String label, byte[] context) {
            this.length = length;
            this.label = ("MLS 1.0 " + label).getBytes(StandardCharsets.UTF_8);
            this.context = context;
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.write(this.length);
            stream.writeOpaque(this.label);
            stream.writeOpaque(this.context);
        }
    }
}

