/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public interface MlsSigner {
    public static final int ecdsa_secp256r1_sha256 = 3;
    public static final int ecdsa_secp521r1_sha512 = 4;
    public static final int ecdsa_secp384r1_sha384 = 5;
    public static final int ed25519 = 7;
    public static final int ed448 = 8;

    public AsymmetricCipherKeyPair generateSignatureKeyPair();

    public byte[] serializePublicKey(AsymmetricKeyParameter var1);

    public byte[] serializePrivateKey(AsymmetricKeyParameter var1);

    public byte[] signWithLabel(byte[] var1, String var2, byte[] var3) throws IOException, CryptoException;

    public boolean verifyWithLabel(byte[] var1, String var2, byte[] var3, byte[] var4) throws IOException;

    public AsymmetricCipherKeyPair deserializePrivateKey(byte[] var1);

    public AsymmetricKeyParameter deserializePublicKey(byte[] var1);
}

