/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.crypto;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.hpke.HPKE;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsAead;
import org.bouncycastle.mls.crypto.MlsKdf;
import org.bouncycastle.mls.crypto.MlsSigner;
import org.bouncycastle.mls.crypto.bc.BcMlsAead;
import org.bouncycastle.mls.crypto.bc.BcMlsKdf;
import org.bouncycastle.mls.crypto.bc.BcMlsSigner;

public class MlsCipherSuite {
    public static final short MLS_128_DHKEMX25519_AES128GCM_SHA256_Ed25519 = 1;
    public static final short MLS_128_DHKEMP256_AES128GCM_SHA256_P256 = 2;
    public static final short MLS_128_DHKEMX25519_CHACHA20POLY1305_SHA256_Ed25519 = 3;
    public static final short MLS_256_DHKEMX448_AES256GCM_SHA512_Ed448 = 4;
    public static final short MLS_256_DHKEMP521_AES256GCM_SHA512_P521 = 5;
    public static final short MLS_256_DHKEMX448_CHACHA20POLY1305_SHA512_Ed448 = 6;
    public static final short MLS_256_DHKEMP384_AES256GCM_SHA384_P384 = 7;
    public static final MlsCipherSuite BCMLS_128_DHKEMX25519_AES128GCM_SHA256_Ed25519 = new MlsCipherSuite(1, new BcMlsSigner(7), new BcMlsKdf((Digest)new SHA256Digest()), new BcMlsAead(1), new HPKE(0, 32, 1, 1));
    public static final MlsCipherSuite BCMLS_128_DHKEMP256_AES128GCM_SHA256_P256 = new MlsCipherSuite(2, new BcMlsSigner(3), new BcMlsKdf((Digest)new SHA256Digest()), new BcMlsAead(1), new HPKE(0, 16, 1, 1));
    public static final MlsCipherSuite BCMLS_128_DHKEMX25519_CHACHA20POLY1305_SHA256_Ed25519 = new MlsCipherSuite(3, new BcMlsSigner(7), new BcMlsKdf((Digest)new SHA256Digest()), new BcMlsAead(3), new HPKE(0, 32, 1, 3));
    public static final MlsCipherSuite BCMLS_256_DHKEMX448_AES256GCM_SHA512_Ed448 = new MlsCipherSuite(4, new BcMlsSigner(8), new BcMlsKdf((Digest)new SHA512Digest()), new BcMlsAead(2), new HPKE(0, 33, 3, 2));
    public static final MlsCipherSuite BCMLS_256_DHKEMP521_AES256GCM_SHA512_P521 = new MlsCipherSuite(5, new BcMlsSigner(4), new BcMlsKdf((Digest)new SHA512Digest()), new BcMlsAead(2), new HPKE(0, 18, 3, 2));
    public static final MlsCipherSuite BCMLS_256_DHKEMX448_CHACHA20POLY1305_SHA512_Ed448 = new MlsCipherSuite(6, new BcMlsSigner(8), new BcMlsKdf((Digest)new SHA512Digest()), new BcMlsAead(3), new HPKE(0, 33, 3, 3));
    public static final MlsCipherSuite BCMLS_256_DHKEMP384_AES256GCM_SHA384_P384 = new MlsCipherSuite(7, new BcMlsSigner(5), new BcMlsKdf((Digest)new SHA384Digest()), new BcMlsAead(2), new HPKE(0, 17, 2, 2));
    public static final short[] ALL_SUPPORTED_SUITES = new short[]{1, 2, 3, 4, 5, 6, 7};
    private final short suiteID;
    private final MlsSigner signer;
    private final MlsKdf kdf;
    private final MlsAead aead;
    private final Digest digest;
    private final HPKE hpke;

    public MlsCipherSuite(short id, MlsSigner signer, MlsKdf kdf, MlsAead aead, HPKE hpke) {
        this.suiteID = id;
        this.signer = signer;
        this.kdf = kdf;
        this.aead = aead;
        this.digest = kdf.getDigest();
        this.hpke = hpke;
    }

    public static MlsCipherSuite getSuite(short id) throws Exception {
        switch (id) {
            case 1: {
                return BCMLS_128_DHKEMX25519_AES128GCM_SHA256_Ed25519;
            }
            case 2: {
                return BCMLS_128_DHKEMP256_AES128GCM_SHA256_P256;
            }
            case 3: {
                return BCMLS_128_DHKEMX25519_CHACHA20POLY1305_SHA256_Ed25519;
            }
            case 4: {
                return BCMLS_256_DHKEMX448_AES256GCM_SHA512_Ed448;
            }
            case 5: {
                return BCMLS_256_DHKEMP521_AES256GCM_SHA512_P521;
            }
            case 6: {
                return BCMLS_256_DHKEMX448_CHACHA20POLY1305_SHA512_Ed448;
            }
            case 7: {
                return BCMLS_256_DHKEMP384_AES256GCM_SHA384_P384;
            }
        }
        throw new Exception("Unkown ciphersuite id");
    }

    public short getSuiteID() {
        return this.suiteID;
    }

    public AsymmetricCipherKeyPair generateSignatureKeyPair() {
        return this.signer.generateSignatureKeyPair();
    }

    public byte[] serializeSignaturePublicKey(AsymmetricKeyParameter key) {
        return this.signer.serializePublicKey(key);
    }

    public byte[] serializeSignaturePrivateKey(AsymmetricKeyParameter key) {
        return this.signer.serializePrivateKey(key);
    }

    public AsymmetricCipherKeyPair deserializeSignaturePrivateKey(byte[] priv) {
        return this.signer.deserializePrivateKey(priv);
    }

    public byte[] signWithLabel(byte[] priv, String label, byte[] content) throws IOException, CryptoException {
        return this.signer.signWithLabel(priv, label, content);
    }

    public boolean verifyWithLabel(byte[] pub, String label, byte[] content, byte[] signature) throws IOException {
        return this.signer.verifyWithLabel(pub, label, content, signature);
    }

    public byte[] refHash(byte[] value, String label) throws IOException {
        RefHash refhash = new RefHash(label.getBytes(StandardCharsets.UTF_8), value);
        byte[] refhashBytes = MLSOutputStream.encode(refhash);
        byte[] out = new byte[this.kdf.getHashLength()];
        this.digest.update(refhashBytes, 0, refhashBytes.length);
        this.digest.doFinal(out, 0);
        return out;
    }

    public byte[] hash(byte[] value) throws IOException {
        byte[] out = new byte[this.kdf.getHashLength()];
        this.digest.update(value, 0, value.length);
        this.digest.doFinal(out, 0);
        return out;
    }

    public byte[] decryptWithLabel(byte[] priv, String label, byte[] context, byte[] kem_output, byte[] ciphertext) throws IOException, InvalidCipherTextException {
        GenericContent encryptContext = new GenericContent(label, context);
        byte[] encryptContextBytes = MLSOutputStream.encode(encryptContext);
        AsymmetricCipherKeyPair kp = this.hpke.deserializePrivateKey(priv, null);
        return this.hpke.open(kem_output, kp, encryptContextBytes, "".getBytes(), ciphertext, null, null, null);
    }

    public byte[][] encryptWithLabel(byte[] pub, String label, byte[] context, byte[] plaintext) throws IOException, InvalidCipherTextException {
        GenericContent encryptContext = new GenericContent(label, context);
        byte[] encryptContextBytes = MLSOutputStream.encode(encryptContext);
        AsymmetricKeyParameter pubKey = this.signer.deserializePublicKey(pub);
        return this.hpke.seal(pubKey, encryptContextBytes, "".getBytes(), plaintext, null, null, null);
    }

    public HPKE getHPKE() {
        return this.hpke;
    }

    public MlsKdf getKDF() {
        return this.kdf;
    }

    public MlsAead getAEAD() {
        return this.aead;
    }

    public static class GenericContent
    implements MLSOutputStream.Writable {
        private byte[] label;
        private byte[] content;

        public GenericContent(String label, byte[] content) {
            this.label = ("MLS 1.0 " + label).getBytes(StandardCharsets.UTF_8);
            this.content = content;
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.writeOpaque(this.label);
            stream.writeOpaque(this.content);
        }
    }

    public static class RefHash
    implements MLSOutputStream.Writable {
        public byte[] label;
        public byte[] value;

        public RefHash(byte[] label, byte[] value) {
            this.label = label;
            this.value = value;
        }

        @Override
        public void writeTo(MLSOutputStream stream) throws IOException {
            stream.writeOpaque(this.label);
            stream.writeOpaque(this.value);
        }
    }
}

