/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class Varint
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    static final int HEADER_OFFSET = 6;
    static final int HEADER_1 = 0;
    static final int HEADER_2 = 16384;
    static final int HEADER_4 = Integer.MIN_VALUE;
    static final int MAX_1 = 63;
    static final int MAX_2 = 16383;
    static final int MAX_4 = 0x3FFFFFFF;
    public final int value;

    public Varint(int value) {
        this.value = value;
    }

    public Varint(MLSInputStream stream) throws IOException {
        int prefix = stream.peek() & 0xFF;
        int logSize = prefix >>> 6;
        int size = 1 << logSize;
        switch (size) {
            case 1: {
                this.value = 0 ^ (Byte)stream.read(Byte.TYPE);
                break;
            }
            case 2: {
                this.value = 0x4000 ^ (Short)stream.read(Short.TYPE);
                break;
            }
            case 4: {
                this.value = Integer.MIN_VALUE ^ (Integer)stream.read(Integer.TYPE);
                break;
            }
            default: {
                throw new IOException("Invalid varint header");
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        if (this.value <= 63) {
            stream.write((byte)(0 | this.value));
        } else if (this.value <= 16383) {
            stream.write((short)(0x4000 | this.value));
        } else if (this.value <= 0x3FFFFFFF) {
            stream.write(Integer.MIN_VALUE | this.value);
        } else {
            throw new IOException("Varint is too big to encode");
        }
    }
}

