/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.AuthenticatedContent;
import org.bouncycastle.mls.codec.AuthenticatedContentTBM;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.FramedContentAuthData;
import org.bouncycastle.mls.codec.FramedContentTBS;
import org.bouncycastle.mls.codec.GroupContext;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.SenderType;
import org.bouncycastle.mls.codec.WireFormat;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.crypto.Secret;
import org.bouncycastle.util.Arrays;

public class PublicMessage
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    FramedContent content;
    FramedContentAuthData auth;
    byte[] membership_tag;

    public PublicMessage(MLSInputStream stream) throws IOException {
        this.content = (FramedContent)stream.read(FramedContent.class);
        this.auth = new FramedContentAuthData(stream, this.content.contentType);
        switch (this.content.sender.senderType) {
            case RESERVED: 
            case EXTERNAL: 
            case NEW_MEMBER_PROPOSAL: 
            case NEW_MEMBER_COMMIT: {
                break;
            }
            case MEMBER: {
                this.membership_tag = stream.readOpaque();
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.content);
        stream.write(this.auth);
        switch (this.content.sender.senderType) {
            case RESERVED: 
            case EXTERNAL: 
            case NEW_MEMBER_PROPOSAL: 
            case NEW_MEMBER_COMMIT: {
                break;
            }
            case MEMBER: {
                stream.writeOpaque(this.membership_tag);
            }
        }
    }

    public PublicMessage(FramedContent content, FramedContentAuthData auth, byte[] membership_tag) {
        this.content = content;
        this.auth = auth;
        switch (content.sender.senderType) {
            case RESERVED: 
            case EXTERNAL: 
            case NEW_MEMBER_PROPOSAL: 
            case NEW_MEMBER_COMMIT: {
                break;
            }
            case MEMBER: {
                this.membership_tag = membership_tag;
            }
        }
    }

    public static PublicMessage protect(AuthenticatedContent authContent, MlsCipherSuite suite, byte[] membershipKeyBytes, byte[] groupContextBytes) throws IOException {
        PublicMessage pt = new PublicMessage(authContent.content, authContent.auth, null);
        if (pt.content.sender.senderType == SenderType.MEMBER) {
            GroupContext context = (GroupContext)MLSInputStream.decode(groupContextBytes, GroupContext.class);
            Secret membershipKey = new Secret(membershipKeyBytes);
            pt.membership_tag = pt.membershipMac(suite, membershipKey, context);
        }
        return pt;
    }

    public AuthenticatedContent unprotect(MlsCipherSuite suite, Secret membership_key, GroupContext context) throws Exception {
        byte[] membershipTag;
        if (this.content.sender.senderType == SenderType.MEMBER && !Arrays.areEqual((byte[])(membershipTag = this.membershipMac(suite, membership_key, context)), (byte[])this.membership_tag)) {
            throw new IOException("incorrect membership tag");
        }
        return new AuthenticatedContent(WireFormat.mls_public_message, this.content, this.auth);
    }

    public byte[] membershipMac(MlsCipherSuite suite, Secret membershipKey, GroupContext context) throws IOException {
        FramedContentTBS tbs = new FramedContentTBS(WireFormat.mls_public_message, this.content, context);
        AuthenticatedContentTBM tbm = new AuthenticatedContentTBM(tbs, this.auth);
        Secret ikm = new Secret(MLSOutputStream.encode(tbm));
        Secret membership_tag = Secret.extract(suite, membershipKey, ikm);
        return membership_tag.value();
    }
}

