/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.Commit;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.FramedContentAuthData;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.Proposal;

class PrivateMessageContent
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    byte[] application_data;
    Proposal proposal;
    Commit commit;
    ContentType contentType;
    FramedContentAuthData auth;
    byte[] padding;

    PrivateMessageContent(MLSInputStream stream, ContentType contentType) throws IOException {
        switch (contentType) {
            case APPLICATION: {
                this.application_data = stream.readOpaque();
                break;
            }
            case PROPOSAL: {
                this.proposal = (Proposal)stream.read(Proposal.class);
                break;
            }
            case COMMIT: {
                this.commit = (Commit)stream.read(Commit.class);
            }
        }
        this.auth = (FramedContentAuthData)stream.read(FramedContentAuthData.class);
        this.padding = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        switch (this.contentType) {
            case APPLICATION: {
                stream.writeOpaque(this.application_data);
                break;
            }
            case PROPOSAL: {
                stream.write(this.proposal);
                break;
            }
            case COMMIT: {
                stream.write(this.commit);
            }
        }
        stream.write(this.auth);
        stream.writeOpaque(this.padding);
    }
}

