/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class GroupContext
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    ProtocolVersion version = ProtocolVersion.mls10;
    short ciphersuite;
    MlsCipherSuite suite;
    byte[] groupID;
    long epoch;
    byte[] treeHash;
    byte[] confirmedTranscriptHash;
    ArrayList<Extension> extensions;

    public byte[] getTreeHash() {
        return this.treeHash;
    }

    public byte[] getConfirmedTranscriptHash() {
        return this.confirmedTranscriptHash;
    }

    public ArrayList<Extension> getExtensions() {
        return this.extensions;
    }

    public GroupContext(MlsCipherSuite ciphersuite, byte[] groupID, long epoch, byte[] treeHash, byte[] confirmedTranscriptHash, ArrayList<Extension> extensions) {
        this.suite = ciphersuite;
        this.ciphersuite = ciphersuite.getSuiteID();
        this.groupID = groupID;
        this.epoch = epoch;
        this.treeHash = treeHash;
        this.confirmedTranscriptHash = confirmedTranscriptHash;
        this.extensions = new ArrayList<Extension>(extensions);
    }

    public GroupContext(MLSInputStream stream) throws Exception {
        this.version = ProtocolVersion.values()[(Short)stream.read(Short.TYPE)];
        this.ciphersuite = (Short)stream.read(Short.TYPE);
        this.suite = MlsCipherSuite.getSuite(this.ciphersuite);
        this.groupID = stream.readOpaque();
        this.epoch = (Long)stream.read(Long.TYPE);
        this.treeHash = stream.readOpaque();
        this.confirmedTranscriptHash = stream.readOpaque();
        this.extensions = new ArrayList();
        stream.readList(this.extensions, Extension.class);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.version);
        stream.write(this.ciphersuite);
        stream.writeOpaque(this.groupID);
        stream.write(this.epoch);
        stream.writeOpaque(this.treeHash);
        stream.writeOpaque(this.confirmedTranscriptHash);
        stream.writeList(this.extensions);
    }
}

