/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.mls.codec.Certificate;
import org.bouncycastle.mls.codec.CredentialType;
import org.bouncycastle.mls.codec.Grease;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class Credential
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    CredentialType credentialType;
    byte[] identity;
    List<Certificate> certificates;

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public static Credential forBasic(byte[] identity) {
        return new Credential(CredentialType.basic, identity, new ArrayList<Certificate>());
    }

    public Credential(CredentialType credentialType, byte[] identity, List<Certificate> certificates) {
        this.credentialType = credentialType;
        this.identity = identity;
        this.certificates = certificates;
    }

    Credential(MLSInputStream stream) throws IOException {
        short credType = (Short)stream.read(Short.TYPE);
        this.credentialType = Grease.isGrease(credType) == -1 ? CredentialType.values()[credType] : CredentialType.values()[3 + Grease.isGrease(credType)];
        switch (this.credentialType) {
            case basic: {
                this.identity = stream.readOpaque();
                break;
            }
            case x509: {
                this.certificates = new ArrayList<Certificate>();
                stream.readList(this.certificates, Certificate.class);
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        if (Grease.isGrease(this.credentialType.value) == -1) {
            stream.write(this.credentialType);
        }
        switch (this.credentialType) {
            case basic: {
                stream.writeOpaque(this.identity);
                break;
            }
            case x509: {
                stream.writeList(this.certificates);
            }
        }
    }
}

