/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import org.bouncycastle.mls.TreeKEM.LeafNodeHashInput;
import org.bouncycastle.mls.TreeKEM.ParentNodeHashInput;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.NodeType;

public class TreeHashInput
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    NodeType nodeType;
    LeafNodeHashInput leafNode;
    ParentNodeHashInput parentNode;

    private TreeHashInput(NodeType nodeType, LeafNodeHashInput leafNode, ParentNodeHashInput parentNode) {
        this.nodeType = nodeType;
        this.leafNode = leafNode;
        this.parentNode = parentNode;
    }

    public static TreeHashInput forLeafNode(LeafNodeHashInput leafNode) {
        return new TreeHashInput(NodeType.leaf, leafNode, null);
    }

    public static TreeHashInput forParentNode(ParentNodeHashInput parentNode) {
        return new TreeHashInput(NodeType.parent, null, parentNode);
    }

    public TreeHashInput(MLSInputStream stream) throws IOException {
        this.nodeType = NodeType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.nodeType) {
            case leaf: {
                this.leafNode = (LeafNodeHashInput)stream.read(LeafNodeHashInput.class);
                break;
            }
            case parent: {
                this.parentNode = (ParentNodeHashInput)stream.read(ParentNodeHashInput.class);
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.nodeType);
        switch (this.nodeType) {
            case leaf: {
                stream.write(this.leafNode);
                break;
            }
            case parent: {
                stream.write(this.parentNode);
            }
        }
    }
}

