/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class ParentNode
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    protected byte[] encryptionKey;
    byte[] parentHash;
    List<LeafIndex> unmerged_leaves;

    public ParentNode(byte[] encryptionKey, byte[] parentHash, List<LeafIndex> unmerged_leaves) {
        this.encryptionKey = (byte[])encryptionKey.clone();
        this.parentHash = (byte[])parentHash.clone();
        this.unmerged_leaves = new ArrayList<LeafIndex>(unmerged_leaves);
    }

    public ParentNode(MLSInputStream stream) throws IOException {
        this.encryptionKey = stream.readOpaque();
        this.parentHash = stream.readOpaque();
        this.unmerged_leaves = new ArrayList<LeafIndex>();
        stream.readList(this.unmerged_leaves, LeafIndex.class);
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.encryptionKey);
        stream.writeOpaque(this.parentHash);
        stream.writeList(this.unmerged_leaves);
    }
}

