/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoField;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

public class LifeTime
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    private final long not_before;
    private final long not_after;

    public LifeTime(MLSInputStream stream) throws IOException {
        this.not_before = (Long)stream.read(Long.TYPE);
        this.not_after = (Long)stream.read(Long.TYPE);
    }

    public LifeTime() {
        this.not_before = 0L;
        this.not_after = -1L;
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.not_before);
        stream.write(this.not_after);
    }

    protected boolean verify() {
        long now = Instant.now().getLong(ChronoField.INSTANT_SECONDS);
        if (this.not_after == -1L) {
            return now >= this.not_before && now < Long.MAX_VALUE;
        }
        return now >= this.not_before && now < this.not_after;
    }
}

