/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls;

import java.io.IOException;
import org.bouncycastle.mls.codec.AuthenticatedContent;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.util.Arrays;

public class TranscriptHash {
    private MlsCipherSuite suite;
    byte[] confirmed;
    byte[] interim;

    public byte[] getConfirmed() {
        return this.confirmed;
    }

    public byte[] getInterim() {
        return this.interim;
    }

    public void setInterim(byte[] interim) {
        this.interim = interim;
    }

    public TranscriptHash(MlsCipherSuite suite) {
        this.suite = suite;
        this.confirmed = new byte[0];
    }

    public TranscriptHash(MlsCipherSuite suite, byte[] confirmed, byte[] interim) {
        this.suite = suite;
        this.confirmed = confirmed;
        this.interim = interim;
    }

    public static TranscriptHash fromConfirmationTag(MlsCipherSuite suite, byte[] confirmed, byte[] confirmationTag) throws IOException {
        TranscriptHash out = new TranscriptHash(suite, (byte[])confirmed.clone(), new byte[0]);
        out.updateInterim(confirmationTag);
        return out;
    }

    public TranscriptHash copy() {
        return new TranscriptHash(this.suite, this.confirmed, this.interim);
    }

    public void update(AuthenticatedContent auth) throws IOException {
        this.updateConfirmed(auth);
        this.updateInterim(auth);
    }

    public void updateConfirmed(AuthenticatedContent auth) throws IOException {
        byte[] transcript = Arrays.concatenate((byte[])this.interim, (byte[])auth.getConfirmedTranscriptHashInput());
        this.confirmed = this.suite.hash(transcript);
    }

    public void updateInterim(AuthenticatedContent auth) throws IOException {
        byte[] transcript = Arrays.concatenate((byte[])this.confirmed, (byte[])auth.getInterimTranscriptHashInput());
        this.interim = this.suite.hash(transcript);
    }

    public void updateInterim(byte[] confirmationTag) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.writeOpaque(confirmationTag);
        byte[] transcript = Arrays.concatenate((byte[])this.confirmed, (byte[])stream.toByteArray());
        this.interim = this.suite.hash(transcript);
    }
}

