/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.AuthenticatedContent;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.GroupInfo;
import org.bouncycastle.mls.codec.KeyPackage;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.PrivateMessage;
import org.bouncycastle.mls.codec.Proposal;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.codec.PublicMessage;
import org.bouncycastle.mls.codec.Sender;
import org.bouncycastle.mls.codec.Welcome;
import org.bouncycastle.mls.codec.WireFormat;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class MLSMessage
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    public ProtocolVersion version;
    public WireFormat wireFormat;
    public PublicMessage publicMessage;
    public PrivateMessage privateMessage;
    public Welcome welcome;
    public GroupInfo groupInfo;
    public KeyPackage keyPackage;

    public MLSMessage(WireFormat wireFormat) {
        this.version = ProtocolVersion.mls10;
        this.wireFormat = wireFormat;
    }

    public static MLSMessage externalProposal(MlsCipherSuite suite, byte[] groupID, long epoch, Proposal proposal, int signerIndex, byte[] sigSk) throws Exception {
        switch (proposal.getProposalType()) {
            case ADD: 
            case REMOVE: 
            case PSK: 
            case REINIT: 
            case GROUP_CONTEXT_EXTENSIONS: {
                break;
            }
            default: {
                throw new Exception("External proposal has invalid type");
            }
        }
        FramedContent content = FramedContent.proposal(groupID, epoch, Sender.forExternal(signerIndex), new byte[0], MLSOutputStream.encode(proposal));
        AuthenticatedContent auth = AuthenticatedContent.sign(WireFormat.mls_public_message, content, suite, sigSk, new byte[0]);
        MLSMessage message = new MLSMessage(WireFormat.mls_public_message);
        message.publicMessage = PublicMessage.protect(auth, suite, new byte[0], new byte[0]);
        return message;
    }

    public static MLSMessage keyPackage(KeyPackage keyPackage) {
        MLSMessage message = new MLSMessage(WireFormat.mls_key_package);
        message.version = ProtocolVersion.mls10;
        message.wireFormat = WireFormat.mls_key_package;
        message.keyPackage = keyPackage;
        return message;
    }

    public MLSMessage(MLSInputStream stream) throws IOException {
        this.version = ProtocolVersion.values()[(Short)stream.read(Short.TYPE)];
        this.wireFormat = WireFormat.values()[(Short)stream.read(Short.TYPE)];
        switch (this.wireFormat) {
            case RESERVED: {
                break;
            }
            case mls_public_message: {
                this.publicMessage = (PublicMessage)stream.read(PublicMessage.class);
                break;
            }
            case mls_private_message: {
                this.privateMessage = (PrivateMessage)stream.read(PrivateMessage.class);
                break;
            }
            case mls_welcome: {
                this.welcome = (Welcome)stream.read(Welcome.class);
                break;
            }
            case mls_group_info: {
                this.groupInfo = (GroupInfo)stream.read(GroupInfo.class);
                break;
            }
            case mls_key_package: {
                this.keyPackage = (KeyPackage)stream.read(KeyPackage.class);
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.version);
        stream.write(this.wireFormat);
        switch (this.wireFormat) {
            case RESERVED: {
                break;
            }
            case mls_public_message: {
                stream.write(this.publicMessage);
                break;
            }
            case mls_private_message: {
                stream.write(this.privateMessage);
                break;
            }
            case mls_welcome: {
                stream.write(this.welcome);
                break;
            }
            case mls_group_info: {
                stream.write(this.groupInfo);
                break;
            }
            case mls_key_package: {
                stream.write(this.keyPackage);
            }
        }
    }

    public ContentType getContentType() {
        switch (this.wireFormat) {
            case mls_public_message: {
                return this.publicMessage.content.getContentType();
            }
            case mls_private_message: {
                return this.privateMessage.content_type;
            }
            case mls_welcome: {
                break;
            }
            case mls_group_info: {
                break;
            }
        }
        return null;
    }

    public MlsCipherSuite getCipherSuite() {
        switch (this.wireFormat) {
            case mls_public_message: 
            case mls_private_message: 
            case mls_group_info: {
                break;
            }
            case mls_welcome: {
                return this.welcome.suite;
            }
            case mls_key_package: {
                return this.keyPackage.suite;
            }
        }
        return null;
    }

    public long getEpoch() {
        switch (this.wireFormat) {
            case mls_public_message: {
                return this.publicMessage.content.epoch;
            }
            case mls_private_message: {
                return this.privateMessage.epoch;
            }
        }
        return -1L;
    }
}

