/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bouncycastle.mls.codec.Varint;

public class MLSInputStream {
    SliceableStream stream;

    public MLSInputStream(byte[] data) {
        this.stream = new SliceableStream(data);
    }

    MLSInputStream(SliceableStream stream) {
        this.stream = stream;
    }

    public static Object decode(byte[] data, Class<?> targetClass) throws IOException {
        MLSInputStream stream = new MLSInputStream(data);
        return stream.read(targetClass);
    }

    public Object read(Class<?> targetClass) throws IOException {
        if (targetClass == Boolean.class) {
            return this.readBoolean();
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return (byte)this.readInt(1);
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return (short)this.readInt(2);
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return (int)this.readInt(4);
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return this.readInt(8);
        }
        if (Readable.class.isAssignableFrom(targetClass)) {
            return this.readReadable(targetClass);
        }
        throw new IllegalArgumentException("Target type cannot be decoded");
    }

    byte peek() throws IOException {
        return this.stream.peek();
    }

    boolean readBoolean() throws IOException {
        switch ((byte)this.readInt(1)) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Invalid boolean value");
    }

    long readInt(byte[] data) {
        long out = 0L;
        for (byte b : data) {
            out <<= 8;
            out |= (long)(b & 0xFF);
        }
        return out;
    }

    long readInt(int size) throws IOException {
        return this.readInt(this.stream.readAll(size));
    }

    public Object readOptional(Class<?> targetClass) throws IOException {
        boolean present = this.readBoolean();
        if (!present) {
            return null;
        }
        return this.read(targetClass);
    }

    public Object readArray(Class<?> elemClass) throws IOException {
        int length = (int)this.readInt(4);
        if (elemClass == Byte.class) {
            return this.stream.readAll(length);
        }
        Object val = Array.newInstance(elemClass, length);
        for (int i = 0; i < length; ++i) {
            Object elem = this.read(elemClass);
            Array.set(val, i, elem);
        }
        return val;
    }

    public byte[] readOpaque() throws IOException {
        Varint size = (Varint)this.read(Varint.class);
        return this.stream.readAll(size.value);
    }

    public <E> void readList(List<E> list, Class<E> elemClass) throws IOException {
        Varint size = (Varint)this.read(Varint.class);
        MLSInputStream dec = new MLSInputStream(this.stream.slice(size.value));
        list.clear();
        while (dec.stream.available() > 0) {
            list.add(dec.read(elemClass));
        }
        this.stream.skip(size.value);
    }

    private Object readReadable(Class<?> targetClass) throws IOException {
        try {
            Constructor<?> constructor = targetClass.getDeclaredConstructor(MLSInputStream.class);
            return constructor.newInstance(this);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Readable class does not have a public MLSInputStream constructor");
        }
        catch (IllegalAccessException e) {
            throw new IOException("Readable class does not have a public MLSInputStream constructor");
        }
        catch (InvocationTargetException e) {
            throw new IOException("InvocationTargetException: " + e.getCause().getMessage());
        }
        catch (InstantiationException e) {
            throw new IOException("InstantiationException: " + e.getMessage());
        }
    }

    public static interface Readable {
    }

    static class SliceableStream
    extends ByteArrayInputStream {
        public SliceableStream(byte[] buf) {
            super(buf);
        }

        public SliceableStream(byte[] buf, int pos, int size) {
            super(buf, pos, size);
        }

        byte[] readAll(int size) throws IOException {
            byte[] data = new byte[size];
            if (size == 0) {
                return data;
            }
            int length = super.read(data);
            if (length != data.length) {
                throw new IOException("Attempt to read beyond end of buffer");
            }
            return data;
        }

        byte peek() throws IOException {
            this.mark(1);
            int val = this.read();
            this.reset();
            if (val == -1) {
                throw new IOException("Attempt to peek past end of buffer");
            }
            return (byte)val;
        }

        SliceableStream slice(int size) throws IOException {
            if (size > this.available()) {
                throw new IOException("Attempt to read past end of buffer");
            }
            return new SliceableStream(this.buf, this.pos, size);
        }
    }
}

