/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.jcajce.interfaces.LMSPrivateKey;
import org.bouncycastle.jcajce.interfaces.LMSPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvLMSPublicKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvLMSPrivateKey
implements Destroyable,
LMSPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient AsymmetricLMSPrivateKey baseKey;

    ProvLMSPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.baseKey = new AsymmetricLMSPrivateKey(keyInfo);
    }

    ProvLMSPrivateKey(AsymmetricLMSPrivateKey baseKey) {
        this.baseKey = baseKey;
    }

    @Override
    public long getIndex() {
        if (this.getUsagesRemaining() == 0L) {
            throw new IllegalStateException("key exhausted");
        }
        return this.baseKey.getIndex();
    }

    @Override
    public long getUsagesRemaining() {
        return this.baseKey.getUsagesRemaining();
    }

    @Override
    public LMSPrivateKey extractKeyShard(int usageCount) {
        return new ProvLMSPrivateKey(this.baseKey.extractKeyShard(usageCount));
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    AsymmetricLMSPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public int getLevels() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey.getL();
    }

    @Override
    public LMSPublicKey getPublicKey() {
        return new ProvLMSPublicKey(new AsymmetricLMSPublicKey(this.baseKey.getL(), this.baseKey.getPublicData()));
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("LMS");
        }
        AsymmetricLMSPublicKey pubKey = new AsymmetricLMSPublicKey(this.baseKey.getL(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvLMSPrivateKey)) {
            return false;
        }
        ProvLMSPrivateKey other = (ProvLMSPrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricLMSPrivateKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

