/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.jcajce.provider.DSAUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvDSAPrivateKey
implements Destroyable,
DSAPrivateKey,
ProvKey<AsymmetricDSAPrivateKey> {
    private static final long serialVersionUID = -4677259546958385734L;
    private transient AsymmetricDSAPrivateKey baseKey;

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKey key) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(key.getParams()), key.getX());
    }

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(keySpec), keySpec.getX());
    }

    ProvDSAPrivateKey(AsymmetricDSAPrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public DSAParams getParams() {
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    @Override
    public AsymmetricDSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "DSA";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DSA");
        }
        try {
            return KeyUtil.privateKeyToString("DSA", this.baseKey.getX(), this.baseKey.getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("DSA");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvDSAPrivateKey)) {
            return false;
        }
        ProvDSAPrivateKey other = (ProvDSAPrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDSAPrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

