/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.Gost3410KeyParameters;
import org.bouncycastle.crypto.general.Gost3410Parameters;
import org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Gost3410Signer
implements DSA {
    Gost3410KeyParameters key;
    SecureRandom random;

    Gost3410Signer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (!(param instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            this.key = (Gost3410PrivateKeyParameters)rParam.getParameters();
            return;
        } else {
            this.key = (Gost3410PublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger m = new BigInteger(1, mRev);
        Gost3410Parameters params = this.key.getParameters();
        while ((k = new BigInteger(params.getQ().bitLength(), this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r = params.getA().modPow(k, params.getP()).mod(params.getQ());
        BigInteger s = k.multiply(m).add(((Gost3410PrivateKeyParameters)this.key).getX().multiply(r)).mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger m = new BigInteger(1, mRev);
        Gost3410Parameters params = this.key.getParameters();
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || params.getQ().compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s) >= 0 || params.getQ().compareTo(s) <= 0) {
            return false;
        }
        BigInteger v = m.modPow(params.getQ().subtract(new BigInteger("2")), params.getQ());
        BigInteger z1 = s.multiply(v).mod(params.getQ());
        BigInteger z2 = params.getQ().subtract(r).multiply(v).mod(params.getQ());
        z1 = params.getA().modPow(z1, params.getP());
        z2 = ((Gost3410PublicKeyParameters)this.key).getY().modPow(z2, params.getP());
        BigInteger u = z1.multiply(z2).mod(params.getP()).mod(params.getQ());
        return u.equals(r);
    }
}

