/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.OperatorNotReadyException;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.general.DSAUtils;
import org.bouncycastle.crypto.general.DSTU4145Signer;
import org.bouncycastle.crypto.general.EC;
import org.bouncycastle.crypto.general.EcGost3410Signer;
import org.bouncycastle.crypto.general.Gost3410Signer;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DSAOutputSigner<T extends Parameters>
implements OutputSignerUsingSecureRandom<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final Initializer initializer;
    private final boolean ready;
    private final boolean reverse;

    DSAOutputSigner(DSA dsa, Digest digest, T parameter, Initializer initializer) {
        this(false, dsa, digest, parameter, initializer, false);
    }

    DSAOutputSigner(DSA dsa, Digest digest, T parameter, Initializer initializer, boolean reverse) {
        this(false, dsa, digest, parameter, initializer, reverse);
    }

    DSAOutputSigner(boolean ready, DSA dsa, Digest digest, T parameter, Initializer initializer, boolean reverse) {
        this.ready = ready;
        this.dsa = dsa;
        this.digest = digest;
        this.parameter = parameter;
        this.initializer = initializer;
        this.reverse = reverse;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getSigningStream() {
        if (!this.ready) {
            if (this.parameter.getAlgorithm().equals(EC.DDSA.getAlgorithm())) {
                this.initializer.initialize(this.dsa, null);
            } else {
                throw new OperatorNotReadyException("Signer requires a SecureRandom to be attached before use");
            }
        }
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getSignature() throws PlainInputProcessingException {
        byte[] m = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(m, 0);
        try {
            return this.encode(this.dsa.generateSignature(m));
        }
        catch (Exception e) {
            throw new PlainInputProcessingException("Unable to create signature: " + e.getMessage(), e);
        }
    }

    @Override
    public int getSignature(byte[] output, int off) throws PlainInputProcessingException {
        byte[] sig = this.getSignature();
        System.arraycopy(sig, 0, output, off, sig.length);
        return sig.length;
    }

    private byte[] encode(BigInteger[] rs) throws IOException {
        if (this.dsa instanceof EcGost3410Signer || this.dsa instanceof Gost3410Signer) {
            int sigMid;
            byte[] sigBytes;
            byte[] r = rs[0].toByteArray();
            byte[] s = rs[1].toByteArray();
            if (r.length > 34 || s.length > 34) {
                sigBytes = new byte[128];
                sigMid = 64;
            } else {
                sigBytes = new byte[64];
                sigMid = 32;
            }
            if (s[0] != 0) {
                System.arraycopy(s, 0, sigBytes, sigMid - s.length, s.length);
            } else {
                System.arraycopy(s, 1, sigBytes, sigMid - (s.length - 1), s.length - 1);
            }
            if (r[0] != 0) {
                System.arraycopy(r, 0, sigBytes, sigBytes.length - r.length, r.length);
            } else {
                System.arraycopy(r, 1, sigBytes, sigBytes.length - (r.length - 1), r.length - 1);
            }
            return sigBytes;
        }
        if (this.dsa instanceof DSTU4145Signer) {
            byte[] s;
            byte[] r = rs[0].toByteArray();
            byte[] sigBytes = new byte[r.length > (s = rs[1].toByteArray()).length ? r.length * 2 : s.length * 2];
            System.arraycopy(s, 0, sigBytes, sigBytes.length / 2 - s.length, s.length);
            System.arraycopy(r, 0, sigBytes, sigBytes.length - r.length, r.length);
            if (this.reverse) {
                DSAUtils.reverseBytes(sigBytes);
            }
            return new DEROctetString(sigBytes).getEncoded();
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(rs[0]));
        v.add(new ASN1Integer(rs[1]));
        return new DERSequence(v).getEncoded("DER");
    }

    @Override
    public DSAOutputSigner<T> withSecureRandom(SecureRandom random) {
        this.initializer.initialize(this.dsa, random);
        return new DSAOutputSigner<T>(true, this.dsa, this.digest, this.parameter, this.initializer, this.reverse);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface Initializer {
        public void initialize(DSA var1, SecureRandom var2);
    }
}

