/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.general.DRBG;

class ContinuousTestingPseudoRNG
implements DRBG {
    private static final int MIN_RESOLUTION = 8;
    private final DRBG drbg;
    private byte[] block;
    private byte[] nextBlock;
    private byte[] initialAdditionalInput;

    ContinuousTestingPseudoRNG(DRBG drbg, byte[] primaryAdditionalInput) {
        this.drbg = drbg;
        this.block = new byte[0];
        this.nextBlock = new byte[0];
        this.initialAdditionalInput = primaryAdditionalInput;
    }

    @Override
    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        if (FipsStatus.isErrorStatus()) {
            throw new FipsOperationError(FipsStatus.getStatusMessage());
        }
        ContinuousTestingPseudoRNG continuousTestingPseudoRNG = this;
        synchronized (continuousTestingPseudoRNG) {
            int rv;
            if (this.block.length != output.length) {
                if (this.block.length < output.length) {
                    this.block = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(output.length)];
                    this.nextBlock = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(output.length)];
                    if (this.initialAdditionalInput != null) {
                        rv = this.drbg.generate(this.block, this.initialAdditionalInput, predictionResistant);
                        this.initialAdditionalInput = null;
                    } else {
                        rv = this.drbg.generate(this.block, null, predictionResistant);
                    }
                    if (rv < 0) {
                        throw new IllegalStateException("DRBG unable to initialise");
                    }
                } else if (this.block.length != 8) {
                    byte[] tmp = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(output.length)];
                    System.arraycopy(this.block, this.block.length - tmp.length, tmp, 0, tmp.length);
                    this.block = tmp;
                    this.nextBlock = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(output.length)];
                }
            }
            if ((rv = this.drbg.generate(this.nextBlock, additionalInput, predictionResistant)) < 0) {
                return rv;
            }
            if (this.areEqual(this.block, this.nextBlock, 0)) {
                throw new IllegalStateException("Duplicate block detected in DRBG output");
            }
            System.arraycopy(this.nextBlock, 0, output, 0, output.length);
            System.arraycopy(this.nextBlock, 0, this.block, 0, this.block.length);
        }
        if (FipsStatus.isErrorStatus()) {
            throw new FipsOperationError(FipsStatus.getStatusMessage());
        }
        return output.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reseed(byte[] additionalInput) {
        FipsStatus.isReady();
        ContinuousTestingPseudoRNG continuousTestingPseudoRNG = this;
        synchronized (continuousTestingPseudoRNG) {
            this.drbg.reseed(additionalInput);
        }
    }

    private boolean areEqual(byte[] a, byte[] b, int bOff) {
        if (bOff + a.length > b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[bOff + i]) continue;
            return false;
        }
        return true;
    }

    private static int getTestBlockSize(int output) {
        if (output < 8) {
            return 8;
        }
        return output;
    }
}

