/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Memoable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SHA256NativeDigest
implements ExtendedDigest,
Memoable {
    protected DigestRefWrapper nativeRef = new DigestRefWrapper(SHA256NativeDigest.makeNative());

    SHA256NativeDigest() {
        this.reset();
    }

    SHA256NativeDigest(SHA256NativeDigest src) {
        this();
        byte[] state = src.getEncodedState();
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), state, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SHA256NativeDigest restoreState(byte[] state, int offset) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), state, offset);
            return this;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDigestSize() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.getDigestSize(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte in) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.update(this.nativeRef.getReference(), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] input, int inOff, int len) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.update(this.nativeRef.getReference(), input, inOff, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] output, int outOff) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.doFinal(this.nativeRef.getReference(), output, outOff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.reset(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByteLength() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.getByteLength(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memoable copy() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return new SHA256NativeDigest(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(Memoable other) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest dig = (SHA256NativeDigest)other;
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), dig.getEncodedState(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEncodedState() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            int l = SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] state = new byte[l];
            SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), state, 0);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreFullState(byte[] encoded, int offset) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, offset);
        }
    }

    public String toString() {
        return "SHA256[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long reference) {
            super(reference);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            SHA256NativeDigest.destroy(reference);
        }
    }
}

