/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.EcMqvBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class EcDHAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final BasicAgreement dh;
    private final T parameter;

    EcDHAgreement(BasicAgreement dh, T parameter) {
        this.dh = dh;
        this.parameter = parameter;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey key) {
        BigInteger z;
        AsymmetricECPublicKey ecKey = (AsymmetricECPublicKey)key;
        EcPublicKeyParameters lwECKey = new EcPublicKeyParameters(ecKey.getW(), EcDHAgreement.getDomainParams(ecKey.getDomainParameters()));
        int length = this.dh.getFieldSize();
        if (this.dh instanceof EcMqvBasicAgreement) {
            AsymmetricECPublicKey ephPublicKey = ((FipsEC.MQVAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
            z = this.dh.calculateAgreement(new EcMqvPublicParameters(lwECKey, new EcPublicKeyParameters(ephPublicKey.getW(), EcDHAgreement.getDomainParams(ephPublicKey.getDomainParameters()))));
        } else {
            z = this.dh.calculateAgreement(lwECKey);
        }
        byte[] zBytes = BigIntegers.asUnsignedByteArray(length, z);
        return FipsKDF.processZBytes(zBytes, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }
}

