/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.OperatorNotReadyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DSAOutputSigner<T extends Parameters>
extends FipsOutputSignerUsingSecureRandom<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final Initializer initializer;
    private final boolean ready;

    DSAOutputSigner(DSA dsa, Digest digest, T parameter, Initializer initializer) {
        this(false, dsa, digest, parameter, initializer);
    }

    DSAOutputSigner(boolean ready, DSA dsa, Digest digest, T parameter, Initializer initializer) {
        this.ready = ready;
        this.dsa = dsa;
        this.digest = digest;
        this.parameter = parameter;
        this.initializer = initializer;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getSigningStream() {
        if (!this.ready) {
            if (this.parameter.getAlgorithm().equals(FipsEC.DDSA.getAlgorithm())) {
                this.initializer.initialize(this.dsa, null);
            } else {
                throw new OperatorNotReadyException("Signer requires a SecureRandom to be attached before use");
            }
        }
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getSignature() throws PlainInputProcessingException {
        byte[] m = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(m, 0);
        try {
            return this.encode(this.dsa.generateSignature(m));
        }
        catch (Exception e) {
            throw new PlainInputProcessingException("Unable to create signature: " + e.getMessage(), e);
        }
    }

    @Override
    public int getSignature(byte[] output, int off) throws PlainInputProcessingException {
        byte[] sig = this.getSignature();
        System.arraycopy(sig, 0, output, off, sig.length);
        return sig.length;
    }

    private byte[] encode(BigInteger[] rs) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(rs[0]));
        v.add(new ASN1Integer(rs[1]));
        return new DERSequence(v).getEncoded("DER");
    }

    @Override
    public DSAOutputSigner<T> withSecureRandom(SecureRandom random) {
        this.initializer.initialize(this.dsa, random);
        return new DSAOutputSigner<T>(true, this.dsa, this.digest, this.parameter, this.initializer);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface Initializer {
        public void initialize(DSA var1, SecureRandom var2);
    }
}

