/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeGCM
implements AEADBlockCipher {
    private GCMRefWrapper refWrapper;
    private int macSize = 0;
    private byte[] nonce;
    private byte[] lastKey;
    private byte[] initialAssociatedText;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private byte[] keptMac = null;
    private static byte[] K = Hex.decode("feffe9928665731c6d6a8f9467308308");
    private static byte[] P = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39");
    private static byte[] A = Hex.decode("feedfacedeadbeeffeedfacedeadbeefabaddad2");
    private static byte[] IV = Hex.decode("cafebabefacedbaddecaf888");
    private static byte[] C = Hex.decode("42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091");
    private static byte[] T = Hex.decode("5bc94fbc3221a5db94fae95ae7121a47");
    private static TestTrigger trigger = new TestTrigger();

    private AESNativeGCM() {
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        BlockCipher engine = (BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine();
        if (this.lastKey != null) {
            engine.init(true, new KeyParameterImpl(this.lastKey));
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            KeyParameter keyParam;
            this.forEncryption = forEncryption;
            byte[] newNonce = null;
            this.keptMac = null;
            if (params instanceof AEADParameters) {
                AEADParameters param = (AEADParameters)params;
                newNonce = param.getNonce();
                this.initialAssociatedText = param.getAssociatedText();
                int macSizeBits = param.getMacSize();
                if (macSizeBits < 32 || macSizeBits > 128 || macSizeBits % 8 != 0) {
                    throw new IllegalArgumentException("invalid value for MAC size: " + macSizeBits);
                }
                this.macSize = macSizeBits;
                keyParam = param.getKey();
            } else if (params instanceof ParametersWithIV) {
                ParametersWithIV param = (ParametersWithIV)params;
                newNonce = param.getIV();
                this.initialAssociatedText = null;
                this.macSize = 128;
                keyParam = (KeyParameter)param.getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            if (newNonce == null || newNonce.length < 12) {
                throw new IllegalArgumentException("IV must be at least 12 bytes");
            }
            if (forEncryption && this.nonce != null && Arrays.areEqual(this.nonce, newNonce)) {
                if (keyParam == null) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
                if (this.lastKey != null && Arrays.areEqual(this.lastKey, keyParam.getKey())) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
            }
            this.nonce = newNonce;
            if (keyParam != null) {
                this.lastKey = keyParam.getKey();
            }
            switch (this.lastKey.length) {
                case 16: 
                case 24: 
                case 32: {
                    break;
                }
                default: {
                    throw new IllegalStateException("key must be only 16,24,or 32 bytes long.");
                }
            }
            this.initRef(this.lastKey.length);
            AESNativeGCM.initNative(this.refWrapper.getReference(), forEncryption, this.lastKey, this.nonce, this.initialAssociatedText, this.macSize);
            this.initialised = true;
        }
    }

    private void initRef(int keySize) {
        this.refWrapper = new GCMRefWrapper(AESNativeGCM.makeNative(keySize, this.forEncryption));
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADByte(byte in) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            AESNativeGCM.processAADByte(this.refWrapper.getReference(), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            AESNativeGCM.processAADBytes(this.refWrapper.getReference(), in, inOff, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processByte(this.refWrapper.getReference(), in, out, outOff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processBytes(this.refWrapper.getReference(), in, inOff, len, out, outOff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.checkStatus();
            int len = AESNativeGCM.doFinal(this.refWrapper.getReference(), out, outOff);
            this.resetKeepMac();
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.keptMac != null) {
                return Arrays.clone(this.keptMac);
            }
            return AESNativeGCM.getMac(this.refWrapper.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateOutputSize(int len) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getUpdateOutputSize(this.refWrapper.getReference(), len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputSize(int len) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getOutputSize(this.refWrapper.getReference(), len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.reset(this.refWrapper.getReference());
            this.initialised = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeepMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.keptMac = this.getMac();
            this.reset(this.refWrapper.getReference());
        }
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6);

    static native long makeNative(int var0, boolean var1);

    static native void dispose(long var0);

    private static native void processAADByte(long var0, byte var2);

    private static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    private static native int processByte(long var0, byte var2, byte[] var3, int var4);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int doFinal(long var0, byte[] var2, int var3);

    private static native int getUpdateOutputSize(long var0, int var2);

    private static native int getOutputSize(long var0, int var2);

    public static native byte[] getMac(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlocksRemainingDown(long value) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.setBlocksRemainingDown(this.refWrapper.getReference(), value);
        }
    }

    private native void setBlocksRemainingDown(long var1, long var3);

    public String toString() {
        if (this.lastKey != null) {
            return "GCM[Native](AES[Native](" + this.lastKey.length * 8 + "))";
        }
        return "GCM[Native](AES[Native](not initialized))";
    }

    static AESNativeGCM newInstance() {
        AESNativeGCM engine = new AESNativeGCM();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.GCM.getAlgorithm(), engine, new BasicKatTest<AESNativeGCM>(){

                @Override
                public boolean hasTestPassed(AESNativeGCM engine) throws Exception {
                    AESNativeGCM encCipher = engine;
                    AEADParameters params = new AEADParameters(new KeyParameterImpl(K), T.length * 8, IV, A);
                    encCipher.init(true, params);
                    byte[] enc = new byte[encCipher.getOutputSize(P.length)];
                    int len = encCipher.processBytes(P, 0, P.length, enc, 0);
                    len += encCipher.doFinal(enc, len);
                    if (enc.length != len) {
                        return false;
                    }
                    byte[] mac = encCipher.getMac();
                    byte[] data = new byte[P.length];
                    System.arraycopy(enc, 0, data, 0, data.length);
                    byte[] tail = new byte[enc.length - P.length];
                    System.arraycopy(enc, P.length, tail, 0, tail.length);
                    if (!Arrays.areEqual(C, data)) {
                        return false;
                    }
                    if (!Arrays.areEqual(T, mac)) {
                        return false;
                    }
                    if (!Arrays.areEqual(T, tail)) {
                        return false;
                    }
                    AESNativeGCM decCipher = engine;
                    decCipher.init(false, params);
                    byte[] dec = new byte[decCipher.getOutputSize(enc.length)];
                    len = decCipher.processBytes(enc, 0, enc.length, dec, 0);
                    decCipher.doFinal(dec, len);
                    mac = decCipher.getMac();
                    data = new byte[C.length];
                    System.arraycopy(dec, 0, data, 0, data.length);
                    engine.refWrapper = null;
                    return Arrays.areEqual(P, data) && Arrays.areEqual(T, mac);
                }
            });
        }
        return engine;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            AESNativeGCM.dispose(reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GCMRefWrapper
    extends NativeReference {
        public GCMRefWrapper(long reference) {
            super(reference);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

