/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeCBC
implements MultiBlockCipher {
    private static byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private static byte[] enc = Hex.decode("c6a13b37878f5b826f4f8162a1c8d879af9d9926f7dac87192b1c4143ad98958");
    private static TestTrigger trigger = new TestTrigger();
    private CBCRefWrapper referenceWrapper;
    byte[] IV = new byte[16];
    int keySize;
    private boolean encrypting;

    private AESNativeCBC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        AESNativeCBC aESNativeCBC = this;
        synchronized (aESNativeCBC) {
            boolean oldEncrypting = this.encrypting;
            this.encrypting = forEncryption;
            if (params instanceof ParametersWithIV) {
                ParametersWithIV ivParam = (ParametersWithIV)params;
                byte[] iv = ivParam.getIV();
                if (iv.length != this.getBlockSize()) {
                    throw new IllegalArgumentException("initialisation vector must be the same length as block size");
                }
                System.arraycopy(iv, 0, this.IV, 0, iv.length);
                this.reset();
                if (ivParam.getParameters() != null) {
                    this.init((KeyParameter)ivParam.getParameters());
                } else {
                    if (oldEncrypting != this.encrypting) {
                        throw new IllegalArgumentException("cannot change encrypting state without providing key");
                    }
                    if (this.referenceWrapper == null) {
                        throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                    }
                    this.init(new KeyParameterImpl(this.referenceWrapper.oldKey));
                }
            } else {
                this.reset();
                if (params != null) {
                    this.init((KeyParameter)params);
                } else {
                    if (oldEncrypting != this.encrypting) {
                        throw new IllegalArgumentException("cannot change encrypting state without providing key.");
                    }
                    if (this.referenceWrapper == null) {
                        throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                    }
                    this.init(new KeyParameterImpl(this.referenceWrapper.oldKey));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(KeyParameter parameters) {
        AESNativeCBC aESNativeCBC = this;
        synchronized (aESNativeCBC) {
            byte[] key = parameters.getKey();
            switch (key.length) {
                case 16: 
                case 24: 
                case 32: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("key must be only 16,24,or 32 bytes long.");
                }
            }
            this.referenceWrapper = new CBCRefWrapper(AESNativeCBC.makeNative(key.length, this.encrypting), Arrays.clone(key));
            if (this.referenceWrapper.getReference() == 0L) {
                throw new IllegalStateException("Native CBC native instance returned a null pointer.");
            }
            AESNativeCBC.init(this.referenceWrapper.getReference(), key, this.IV);
            this.keySize = key.length * 8;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CBC";
    }

    @Override
    public int getBlockSize() {
        return AESNativeCBC.getBlockSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        AESNativeCBC aESNativeCBC = this;
        synchronized (aESNativeCBC) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCBC.process(this.referenceWrapper.getReference(), in, inOff, 1, out, outOff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeCBC aESNativeCBC = this;
        synchronized (aESNativeCBC) {
            if (this.referenceWrapper == null) {
                return;
            }
            AESNativeCBC.reset(this.referenceWrapper.getReference());
        }
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCBC.getMultiBlockSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        AESNativeCBC aESNativeCBC = this;
        synchronized (aESNativeCBC) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCBC.process(this.referenceWrapper.getReference(), in, inOff, blockCount, out, outOff);
        }
    }

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeNative(int var0, boolean var1);

    static native void init(long var0, byte[] var2, byte[] var3);

    static native void dispose(long var0);

    private static native void reset(long var0);

    public String toString() {
        return "CBC[Native](AES[Native](" + this.keySize + ")";
    }

    static AESNativeCBC newInstance() {
        AESNativeCBC engine = new AESNativeCBC();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.CBC.getAlgorithm(), engine, new BasicKatTest<AESNativeCBC>(){

                @Override
                public boolean hasTestPassed(AESNativeCBC cbcCipher) throws Exception {
                    byte[] data = new byte[32];
                    byte[] buf = new byte[32];
                    byte[] iv = new byte[16];
                    cbcCipher.init(true, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    cbcCipher.processBlocks(data, 0, 2, buf, 0);
                    if (!Arrays.areEqual(enc, buf)) {
                        return false;
                    }
                    cbcCipher.init(false, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    cbcCipher.processBlocks(enc, 0, 2, buf, 0);
                    cbcCipher.referenceWrapper = null;
                    return Arrays.areEqual(data, buf);
                }
            });
        }
        return engine;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class CBCRefWrapper
    extends NativeReference {
        private final byte[] oldKey;

        public CBCRefWrapper(long reference, byte[] oldKey) {
            super(reference);
            this.oldKey = oldKey;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.oldKey);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] oldKey;

        Disposer(long ref, byte[] oldKey) {
            super(ref);
            this.oldKey = oldKey;
        }

        @Override
        protected void dispose(long reference) {
            Arrays.clear(this.oldKey);
            AESNativeCBC.dispose(reference);
        }
    }
}

