/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410NamedParameters;
import org.bouncycastle.asn1.cryptopro.GOST3410ParamSetParameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GOST3410Parameters<T> {
    private final ASN1ObjectIdentifier publicKeyParamSet;
    private final ASN1ObjectIdentifier digestParamSet;
    private final ASN1ObjectIdentifier encryptionParamSet;
    private final T domainParameters;

    public GOST3410Parameters(ASN1ObjectIdentifier publicKeyParamSet) {
        this(publicKeyParamSet, CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet, null, GOST3410Parameters.getDomainParameters(publicKeyParamSet));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier publicKeyParamSet, ASN1ObjectIdentifier digestParamSet) {
        this(publicKeyParamSet, digestParamSet, null, GOST3410Parameters.getDomainParameters(publicKeyParamSet));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier publicKeyParamSet, ASN1ObjectIdentifier digestParamSet, ASN1ObjectIdentifier encryptionParamSet) {
        this(publicKeyParamSet, digestParamSet, encryptionParamSet, GOST3410Parameters.getDomainParameters(publicKeyParamSet));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier publicKeyParamSet, ASN1ObjectIdentifier digestParamSet, T domainParameters) {
        this(publicKeyParamSet, digestParamSet, null, domainParameters);
    }

    public GOST3410Parameters(ASN1ObjectIdentifier publicKeyParamSet, ASN1ObjectIdentifier digestParamSet, ASN1ObjectIdentifier encryptionParamSet, T domainParameters) {
        this.publicKeyParamSet = publicKeyParamSet;
        this.digestParamSet = digestParamSet;
        this.encryptionParamSet = encryptionParamSet;
        this.domainParameters = domainParameters;
    }

    public ASN1ObjectIdentifier getPublicKeyParamSet() {
        return this.publicKeyParamSet;
    }

    public ASN1ObjectIdentifier getDigestParamSet() {
        return this.digestParamSet;
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.encryptionParamSet;
    }

    public T getDomainParameters() {
        return this.domainParameters;
    }

    private static Object getDomainParameters(ASN1ObjectIdentifier oid) {
        GOST3410ParamSetParameters params = GOST3410NamedParameters.getByOID(oid);
        if (params != null) {
            return new GOST3410DomainParameters(params.getKeySize(), params.getP(), params.getQ(), params.getA());
        }
        X9ECParameters ecParams = ECGOST3410NamedCurves.getByOIDX9(oid);
        return new NamedECDomainParameters(oid, ecParams.getCurve(), ecParams.getG(), ecParams.getN(), ecParams.getH());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GOST3410Parameters)) {
            return false;
        }
        GOST3410Parameters that = (GOST3410Parameters)o;
        if (this.digestParamSet != null ? !this.digestParamSet.equals(that.digestParamSet) : that.digestParamSet != null) {
            return false;
        }
        if (this.domainParameters != null ? !this.domainParameters.equals(that.domainParameters) : that.domainParameters != null) {
            return false;
        }
        if (this.encryptionParamSet != null ? !this.encryptionParamSet.equals(that.encryptionParamSet) : that.encryptionParamSet != null) {
            return false;
        }
        return !(this.publicKeyParamSet != null ? !this.publicKeyParamSet.equals(that.publicKeyParamSet) : that.publicKeyParamSet != null);
    }

    public int hashCode() {
        int result = this.publicKeyParamSet != null ? this.publicKeyParamSet.hashCode() : 0;
        result = 31 * result + (this.digestParamSet != null ? this.digestParamSet.hashCode() : 0);
        result = 31 * result + (this.encryptionParamSet != null ? this.encryptionParamSet.hashCode() : 0);
        result = 31 * result + (this.domainParameters != null ? this.domainParameters.hashCode() : 0);
        return result;
    }
}

