/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc7748;

import java.security.SecureRandom;
import org.bouncycastle.math.ec.rfc7748.X448Field;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class X448 {
    public static final int POINT_SIZE = 56;
    public static final int SCALAR_SIZE = 56;
    private static final int C_A = 156326;
    private static final int C_A24 = 39082;

    public static boolean calculateAgreement(byte[] k, int kOff, byte[] u, int uOff, byte[] r, int rOff) {
        X448.scalarMult(k, kOff, u, uOff, r, rOff);
        return !Arrays.areAllZeroes(r, rOff, 56);
    }

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        for (int i = 0; i < 14; ++i) {
            n[i] = X448.decode32(k, kOff + i * 4);
        }
        n[0] = n[0] & 0xFFFFFFFC;
        n[13] = n[13] | Integer.MIN_VALUE;
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k) {
        random.nextBytes(k);
        k[0] = (byte)(k[0] & 0xFC);
        k[55] = (byte)(k[55] | 0x80);
    }

    public static void generatePublicKey(byte[] k, int kOff, byte[] r, int rOff) {
        X448.scalarMultBase(k, kOff, r, rOff);
    }

    private static void pointDouble(int[] x, int[] z) {
        int[] A = X448Field.create();
        int[] B = X448Field.create();
        X448Field.add(x, z, A);
        X448Field.sub(x, z, B);
        X448Field.sqr(A, A);
        X448Field.sqr(B, B);
        X448Field.mul(A, B, x);
        X448Field.sub(A, B, A);
        X448Field.mul(A, 39082, z);
        X448Field.add(z, B, z);
        X448Field.mul(z, A, z);
    }

    public static void precompute() {
        Ed448.precompute();
    }

    public static void scalarMult(byte[] k, int kOff, byte[] u, int uOff, byte[] r, int rOff) {
        int[] n = new int[14];
        X448.decodeScalar(k, kOff, n);
        int[] x1 = X448Field.create();
        X448Field.decode(u, uOff, x1);
        int[] x2 = X448Field.create();
        X448Field.copy(x1, 0, x2, 0);
        int[] z2 = X448Field.create();
        z2[0] = 1;
        int[] x3 = X448Field.create();
        x3[0] = 1;
        int[] z3 = X448Field.create();
        int[] t1 = X448Field.create();
        int[] t2 = X448Field.create();
        int bit = 447;
        int swap = 1;
        do {
            X448Field.add(x3, z3, t1);
            X448Field.sub(x3, z3, x3);
            X448Field.add(x2, z2, z3);
            X448Field.sub(x2, z2, x2);
            X448Field.mul(t1, x2, t1);
            X448Field.mul(x3, z3, x3);
            X448Field.sqr(z3, z3);
            X448Field.sqr(x2, x2);
            X448Field.sub(z3, x2, t2);
            X448Field.mul(t2, 39082, z2);
            X448Field.add(z2, x2, z2);
            X448Field.mul(z2, t2, z2);
            X448Field.mul(x2, z3, x2);
            X448Field.sub(t1, x3, z3);
            X448Field.add(t1, x3, x3);
            X448Field.sqr(x3, x3);
            X448Field.sqr(z3, z3);
            X448Field.mul(z3, x1, z3);
            int word = --bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X448Field.cswap(swap ^= kt, x2, x3);
            X448Field.cswap(swap, z2, z3);
            swap = kt;
        } while (bit >= 2);
        for (int i = 0; i < 2; ++i) {
            X448.pointDouble(x2, z2);
        }
        X448Field.inv(z2, z2);
        X448Field.mul(x2, z2, x2);
        X448Field.normalize(x2);
        X448Field.encode(x2, r, rOff);
    }

    public static void scalarMultBase(byte[] k, int kOff, byte[] r, int rOff) {
        int[] x = X448Field.create();
        int[] y = X448Field.create();
        Ed448.scalarMultBaseXY(Friend.INSTANCE, k, kOff, x, y);
        X448Field.inv(x, x);
        X448Field.mul(x, y, x);
        X448Field.sqr(x, x);
        X448Field.normalize(x);
        X448Field.encode(x, r, rOff);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }
}

