/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRSAPublicKey
implements RSAPublicKey,
ProvKey<AsymmetricRSAPublicKey> {
    static final long serialVersionUID = 2675817738516720772L;
    private transient AsymmetricRSAPublicKey baseKey;

    ProvRSAPublicKey(Algorithm algorithm, RSAPublicKey baseKey) {
        this.baseKey = new AsymmetricRSAPublicKey(algorithm, baseKey.getModulus(), baseKey.getPublicExponent());
    }

    ProvRSAPublicKey(Algorithm algorithm, RSAPublicKeySpec baseKey) {
        this.baseKey = new AsymmetricRSAPublicKey(algorithm, baseKey.getModulus(), baseKey.getPublicExponent());
    }

    ProvRSAPublicKey(AsymmetricRSAPublicKey baseKey) {
        this.baseKey = baseKey;
    }

    @Override
    public AsymmetricRSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.baseKey.getPublicExponent();
    }

    @Override
    public String getAlgorithm() {
        if ("RSA/PSS".equals(this.baseKey.getAlgorithm().getName())) {
            return "RSASSA-PSS";
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RSAPublicKey)) {
            return false;
        }
        if (o instanceof ProvRSAPublicKey) {
            ProvRSAPublicKey other = (ProvRSAPublicKey)o;
            return this.baseKey.equals(other.baseKey);
        }
        RSAPublicKey other = (RSAPublicKey)o;
        return Arrays.areEqual(this.getEncoded(), other.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricRSAPublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = Strings.lineSeparator();
        buf.append("RSA Public Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("]").append(",[").append(KeyUtil.generateExponentFingerprint(this.getPublicExponent())).append("]").append(nl);
        buf.append("        modulus: ").append(this.getModulus().toString(16)).append(nl);
        buf.append("public exponent: ").append(this.getPublicExponent().toString(16)).append(nl);
        return buf.toString();
    }
}

