/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreParameters;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertStoreCollectionSpi;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi;
import org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi_8;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi_8;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvPKIX
extends AsymmetricAlgorithmProvider {
    private static final Class revChkClass = ClassUtil.lookup("java.security.cert.PKIXRevocationChecker");

    ProvPKIX() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        if (revChkClass != null) {
            provider.addAlgorithmImplementation("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new PKIXCertPathValidatorSpi_8(provider);
                }
            });
            provider.addAlgorithmImplementation("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new PKIXCertPathBuilderSpi_8(provider);
                }
            });
        } else {
            provider.addAlgorithmImplementation("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new PKIXCertPathValidatorSpi(provider);
                }
            });
            provider.addAlgorithmImplementation("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new PKIXCertPathBuilderSpi(provider);
                }
            });
        }
        provider.addAlgorithmImplementation("CertStore.COLLECTION", "org.bouncycastle.jce.provider.CertStoreCollectionSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                try {
                    return new CertStoreCollectionSpi((CertStoreParameters)constructorParameter);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new NoSuchAlgorithmException("Unable to construct CertStore implementation: " + e.getMessage(), e);
                }
            }
        });
    }
}

