/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.PBKDF2Key;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.jcajce.spec.PBKDF2ParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvPBEPBKDF2
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBEPBKDF2.class.getName();

    ProvPBEPBKDF2() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("AlgorithmParameters.PBKDF2", PREFIX + "$AlgParams", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new AlgParams();
            }
        });
        provider.addAlias("AlgorithmParameters", "PBKDF2", "PBKDF2WITHUTF8", "PBKDF2WITHASCII", "PBKDF2WITH8BIT");
        provider.addAlias("AlgorithmParameters", "PBKDF2", PKCSObjectIdentifiers.id_PBKDF2);
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2", PREFIX + "$PBKDF2withUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA1andUTF8", PasswordConverter.UTF8);
            }
        });
        provider.addAlias("SecretKeyFactory", "PBKDF2", "PBKDF2WITHUTF8");
        provider.addAlias("SecretKeyFactory", "PBKDF2", PKCSObjectIdentifiers.id_PBKDF2);
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA1", PREFIX + "$PBKDF2withHMACSHA1andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA1andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA1_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA224", PREFIX + "$PBKDF2withHMACSHA224andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA224andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA224_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA256", PREFIX + "$PBKDF2withHMACSHA256andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA256andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA256_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA384", PREFIX + "$PBKDF2withHMACSHA384andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA384andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA384_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA512", PREFIX + "$PBKDF2withHMACSHA512andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA512andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA512_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA3-224", PREFIX + "$PBKDF2withHMACSHA3-224andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA3-224andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA3_224_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA3-256", PREFIX + "$PBKDF2withHMACSHA3-256andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA3-256andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA3_256_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA3-384", PREFIX + "$PBKDF2withHMACSHA3-384andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA3-384andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA3_384_HMAC);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA3-512", PREFIX + "$PBKDF2withHMACSHA3-512andUTF8", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA3-512andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA3_512_HMAC);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACGOST3411", PREFIX + "$PBKDF2withHMACGOST3411andUTF8", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BasePBKDF2("PBKDF2withHmacGOST3411andUTF8", PasswordConverter.UTF8, SecureHash.Algorithm.GOST3411_HMAC);
                }
            }));
        }
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHASCII", PREFIX + "$PBKDF2withASCII", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BasePBKDF2("PBKDF2withHmacSHA1and8BIT", PasswordConverter.ASCII);
            }
        });
        provider.addAlias("SecretKeyFactory", "PBKDF2WITHASCII", "PBKDF2WITH8BIT");
    }

    private static String convertToJCA(Algorithm algorithm) {
        String algName = algorithm.getName();
        int slash = algName.indexOf(47);
        int dash = algName.indexOf(45);
        if (dash > 0) {
            return algName.substring(0, dash) + algName.substring(dash + 1, slash);
        }
        return algName.substring(0, slash);
    }

    private static DigestAlgorithm getPrfAlgorithm(ASN1ObjectIdentifier algorithm) throws InvalidKeySpecException {
        if (algorithm.equals(CryptoProObjectIdentifiers.gostR3411Hmac)) {
            return SecureHash.Algorithm.GOST3411_HMAC;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA1)) {
            return FipsSHS.Algorithm.SHA1_HMAC;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA224)) {
            return FipsSHS.Algorithm.SHA224_HMAC;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA256)) {
            return FipsSHS.Algorithm.SHA256_HMAC;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA384)) {
            return FipsSHS.Algorithm.SHA384_HMAC;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
            return FipsSHS.Algorithm.SHA512_HMAC;
        }
        throw new InvalidKeySpecException("Invalid KeySpec: unknown PRF algorithm " + algorithm);
    }

    static byte[] getSecretKey(SecretKey pbeKey, PBEParameterSpec pbeSpec, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
        PasswordBasedDeriver<FipsPBKD.Parameters> deriver = new FipsPBKD.DeriverFactory().createDeriver(FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA1_HMAC, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKey(keyType, (keySizeInBits + 7) / 8);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class BasePBKDF2
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final PasswordConverter passwordConverter;
        private final DigestAlgorithm defaultPrf;

        public BasePBKDF2(String algName, PasswordConverter passwordConverter) {
            this(algName, passwordConverter, FipsSHS.Algorithm.SHA1_HMAC);
        }

        public BasePBKDF2(String algName, PasswordConverter passwordConverter, DigestAlgorithm defaultPrf) {
            this.algName = algName;
            this.passwordConverter = passwordConverter;
            this.defaultPrf = defaultPrf;
        }

        @Override
        public SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    return new PBKDF2Key(((PBEKeySpec)keySpec).getPassword(), this.passwordConverter);
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("Positive key length required: " + pbeSpec.getKeyLength());
                }
                DigestAlgorithm prfAlg = this.defaultPrf;
                Object keyAlg = this.algName;
                if (pbeSpec instanceof PBKDF2KeySpec && !((PBKDF2KeySpec)pbeSpec).isDefaultPrf()) {
                    PBKDF2KeySpec spec = (PBKDF2KeySpec)pbeSpec;
                    prfAlg = ProvPBEPBKDF2.getPrfAlgorithm(spec.getPrf().getAlgorithm());
                    keyAlg = this.passwordConverter == PasswordConverter.UTF8 ? "PBKDF2withHmac" + ProvPBEPBKDF2.convertToJCA(prfAlg) + "andUTF8" : "PBKDF2withHmac" + ProvPBEPBKDF2.convertToJCA(prfAlg) + "and8BIT";
                }
                PasswordBasedDeriver<Parameters> deriver = prfAlg instanceof FipsAlgorithm ? new FipsPBKD.DeriverFactory().createDeriver(FipsPBKD.PBKDF2.using((FipsDigestAlgorithm)prfAlg, this.passwordConverter, pbeSpec.getPassword()).withSalt(pbeSpec.getSalt()).withIterationCount(pbeSpec.getIterationCount())) : new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF2.using(prfAlg, this.passwordConverter, pbeSpec.getPassword()).withSalt(pbeSpec.getSalt()).withIterationCount(pbeSpec.getIterationCount()));
                return new PBKDFPBEKey(deriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, (pbeSpec.getKeyLength() + 7) / 8), (String)keyAlg, pbeSpec);
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBKDF2Params params;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            if (paramSpec == PBKDF2ParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                int keySize;
                int n = keySize = this.params.getKeyLength() != null ? this.params.getKeyLength().intValue() * 8 : 0;
                if (this.params.isDefaultPrf()) {
                    return new PBKDF2ParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue(), keySize);
                }
                return new PBKDF2ParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue(), keySize, this.params.getPrf());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
            }
            if (paramSpec instanceof PBKDF2ParameterSpec) {
                PBKDF2ParameterSpec pbeSpec = (PBKDF2ParameterSpec)paramSpec;
                this.params = new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount(), pbeSpec.getKeySize() / 8, pbeSpec.getPrf());
            } else {
                PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
                this.params = new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount());
            }
        }

        @Override
        protected void localInit(byte[] params) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(params));
        }

        @Override
        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }
}

