/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IVAlgorithmParameterGenerator
extends BaseAlgorithmParameterGenerator {
    private final String algorithm;
    private final int ivLength;

    IVAlgorithmParameterGenerator(BouncyCastleFipsProvider fipsProvider, String algorithm, int ivLength) {
        super(fipsProvider, 0);
        this.algorithm = algorithm;
        this.ivLength = ivLength;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for " + this.algorithm + " parameter generation");
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters params;
        byte[] iv = new byte[this.ivLength];
        this.random.nextBytes(iv);
        try {
            params = AlgorithmParameters.getInstance(this.algorithm, this.fipsProvider);
            params.init(new IvParameterSpec(iv));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return params;
    }
}

