/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.MessageDigest;
import org.bouncycastle.crypto.OutputDigestCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    private final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters algorithm) {
        this(fipsFactory.createOutputDigestCalculator(algorithm));
    }

    BaseMessageDigest(OutputDigestCalculator digestCalculator) {
        super(((Parameters)digestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = digestCalculator;
        this.digestStream = digestCalculator.getDigestStream();
    }

    @Override
    protected void engineReset() {
        this.digestCalculator.reset();
    }

    @Override
    protected void engineUpdate(byte input) {
        this.digestStream.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.digestStream.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digestBytes = this.digestCalculator.getDigest();
        this.engineReset();
        return digestBytes;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

