/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class KTSKeyWithEncapsulation
implements SecretKey {
    private final SecretKey secretKey;
    private final byte[] encapsulation;

    public KTSKeyWithEncapsulation(SecretKey secretKey, byte[] encapsulation) {
        this.secretKey = secretKey;
        this.encapsulation = Arrays.clone(encapsulation);
    }

    @Override
    public String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.secretKey.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.secretKey.getEncoded();
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.encapsulation);
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.secretKey instanceof AgreedKeyWithMacKey) {
            return ((AgreedKeyWithMacKey)this.secretKey).getMacKey();
        }
        return null;
    }

    public boolean equals(Object o) {
        return this.secretKey.equals(o);
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }
}

