/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HKDFKeyParameters {
    private final byte[] ikm;
    private final boolean skipExpand;
    private final byte[] salt;

    public HKDFKeyParameters(byte[] ikm, boolean skip, byte[] salt) {
        if (ikm == null) {
            throw new IllegalArgumentException("IKM (input keying material) should not be null");
        }
        this.ikm = Arrays.clone(ikm);
        this.skipExpand = skip;
        this.salt = (byte[])(salt == null || salt.length == 0 ? null : Arrays.clone(salt));
    }

    public byte[] getIKM() {
        return Arrays.clone(this.ikm);
    }

    public boolean skipExtract() {
        return this.skipExpand;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }
}

