/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.params.DesParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DesEdeParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public static boolean isWeakKey(byte[] key, int offset, int length) {
        for (int i = offset; i < length; i += 8) {
            if (!DesParameters.isWeakKey(key, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRealEDEKey(byte[] key) {
        return key.length == 16 ? DesEdeParameters.isReal2Key(key) : DesEdeParameters.isReal3Key(key);
    }

    public static boolean isReal2Key(byte[] key) {
        boolean isValid = false;
        for (int i = 0; i != 8; ++i) {
            if (key[i] == key[i + 8]) continue;
            isValid = true;
        }
        return isValid;
    }

    public static boolean isReal3Key(byte[] key) {
        boolean diff12 = false;
        boolean diff13 = false;
        boolean diff23 = false;
        for (int i = 0; i != 8; ++i) {
            diff12 |= key[i] != key[i + 8];
            diff13 |= key[i] != key[i + 16];
            diff23 |= key[i + 8] != key[i + 16];
        }
        return diff12 && diff13 && diff23;
    }

    public static boolean isActuallyDesKey(byte[] key) {
        boolean isDesKey = true;
        if (key.length == 16) {
            for (int i = 0; i != 8; ++i) {
                if (key[i] == key[i + 8]) continue;
                isDesKey = false;
            }
        } else {
            for (int i = 0; i != 8; ++i) {
                if (key[i] == key[i + 8] && key[i + 8] == key[i + 16]) continue;
                isDesKey = false;
            }
        }
        return isDesKey;
    }
}

