/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.SkippingCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CipherInputStream
extends FilterInputStream {
    private static final int INPUT_BUF_SIZE = 2048;
    private final String algorithmName;
    private final boolean isApprovedMode;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADCipher aeadBlockCipher;
    private byte[] buf;
    private byte[] markBuf;
    private final byte[] inBuf = new byte[2048];
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private long markPosition;
    private int markBufOff;

    public CipherInputStream(InputStream is, BufferedBlockCipher cipher) {
        super(is);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getUnderlyingCipher().getAlgorithmName();
        this.bufferedBlockCipher = cipher;
    }

    public CipherInputStream(InputStream is, StreamCipher cipher) {
        super(is);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getAlgorithmName();
        this.streamCipher = cipher;
    }

    public CipherInputStream(InputStream is, AEADCipher cipher) {
        super(is);
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getAlgorithmName();
        this.aeadBlockCipher = cipher;
    }

    private int nextChunk() throws IOException {
        if (this.finalized) {
            return -1;
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        while (this.maxBuf == 0) {
            int read = this.in.read(this.inBuf);
            if (read == -1) {
                this.finaliseCipher();
                if (this.maxBuf == 0) {
                    return -1;
                }
                return this.maxBuf;
            }
            try {
                this.ensureCapacity(read, false);
                if (this.bufferedBlockCipher != null) {
                    this.maxBuf = this.bufferedBlockCipher.processBytes(this.inBuf, 0, read, this.buf, 0);
                    continue;
                }
                if (this.aeadBlockCipher != null) {
                    this.maxBuf = this.aeadBlockCipher.processBytes(this.inBuf, 0, read, this.buf, 0);
                    continue;
                }
                this.streamCipher.processBytes(this.inBuf, 0, read, this.buf, 0);
                this.maxBuf = read;
            }
            catch (Exception e) {
                throw new StreamIOException("Error processing stream ", e);
            }
        }
        return this.maxBuf;
    }

    private void finaliseCipher() throws IOException {
        try {
            this.finalized = true;
            this.ensureCapacity(0, true);
            this.maxBuf = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.doFinal(this.buf, 0) : (this.aeadBlockCipher != null ? this.aeadBlockCipher.doFinal(this.buf, 0) : 0);
        }
        catch (org.bouncycastle.crypto.internal.InvalidCipherTextException e) {
            throw new InvalidCipherTextException("Error finalising cipher", e);
        }
        catch (Exception e) {
            throw new IOException("Error finalising cipher " + e);
        }
    }

    @Override
    public int read() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int toSupply = Math.min(len, this.available());
        System.arraycopy(this.buf, this.bufOff, b, off, toSupply);
        this.bufOff += toSupply;
        return toSupply;
    }

    @Override
    public long skip(long n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (n <= 0L) {
            return 0L;
        }
        if (this.streamCipher instanceof SkippingCipher) {
            long cSkip;
            int avail = this.available();
            if (n <= (long)avail) {
                this.bufOff = (int)((long)this.bufOff + n);
                return n;
            }
            this.bufOff = this.maxBuf;
            long skip = this.in.skip(n - (long)avail);
            if (skip != (cSkip = ((SkippingCipher)((Object)this.streamCipher)).skip(skip))) {
                throw new IOException("Unable to skip cipher " + skip + " bytes.");
            }
            return skip + (long)avail;
        }
        int skip = (int)Math.min(n, (long)this.available());
        this.bufOff += skip;
        return skip;
    }

    @Override
    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    private void ensureCapacity(int updateSize, boolean finalOutput) {
        int bufLen = updateSize;
        if (finalOutput) {
            if (this.bufferedBlockCipher != null) {
                bufLen = this.bufferedBlockCipher.getOutputSize(updateSize);
            } else if (this.aeadBlockCipher != null) {
                bufLen = this.aeadBlockCipher.getOutputSize(updateSize);
            }
        } else if (this.bufferedBlockCipher != null) {
            bufLen = this.bufferedBlockCipher.getUpdateOutputSize(updateSize);
        } else if (this.aeadBlockCipher != null) {
            bufLen = this.aeadBlockCipher.getUpdateOutputSize(updateSize);
        }
        if (this.buf == null || this.buf.length < bufLen) {
            this.buf = new byte[bufLen];
        }
    }

    @Override
    public void close() throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        try {
            this.in.close();
        }
        finally {
            if (!this.finalized) {
                this.finaliseCipher();
            }
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        this.markBufOff = 0;
        this.markPosition = 0L;
        if (this.markBuf != null) {
            Arrays.fill(this.markBuf, (byte)0);
            this.markBuf = null;
        }
        if (this.buf != null) {
            Arrays.fill(this.buf, (byte)0);
            this.buf = null;
        }
        Arrays.fill(this.inBuf, (byte)0);
    }

    @Override
    public void mark(int readlimit) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.in.mark(readlimit);
        if (this.streamCipher instanceof SkippingCipher) {
            SkippingCipher skip = (SkippingCipher)((Object)this.streamCipher);
            this.markPosition = skip.getPosition();
        }
        if (this.buf != null) {
            this.markBuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, this.markBuf, 0, this.buf.length);
        }
        this.markBufOff = this.bufOff;
    }

    @Override
    public void reset() throws IOException {
        if (!(this.streamCipher instanceof SkippingCipher)) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        SkippingCipher skip = (SkippingCipher)((Object)this.streamCipher);
        skip.seekTo(this.markPosition);
        if (this.markBuf != null) {
            this.buf = this.markBuf;
        }
        this.bufOff = this.markBufOff;
    }

    @Override
    public boolean markSupported() {
        if (this.streamCipher instanceof SkippingCipher) {
            return this.in.markSupported();
        }
        return false;
    }
}

