/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal;

import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class DefaultMultiBlockCipher
implements MultiBlockCipher {
    protected DefaultMultiBlockCipher() {
    }

    @Override
    public int getMultiBlockSize() {
        return this.getBlockSize();
    }

    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int resultLen = 0;
        int blockSize = this.getMultiBlockSize();
        for (int i = 0; i != blockCount; ++i) {
            resultLen += this.processBlock(in, inOff, out, outOff + resultLen);
            inOff += blockSize;
        }
        return resultLen;
    }
}

