/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TripleDES {
    public static final Algorithm ALGORITHM = FipsTripleDES.ALGORITHM;
    public static final AuthParameters CBC_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC));
    public static final AuthParameters CBC_MACwithISO7816_4 = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC, Padding.ISO7816_4));
    public static final AuthParameters CFB8_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CFB8MAC));
    public static final Parameters OpenPGPCFB = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.OpenPGPCFB));
    public static final AuthParameters EAX = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.EAX));
    public static final Parameters RFC3217_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3217_WRAP));
    public static final Parameters RFC3211_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3211_WRAP));

    private TripleDES() {
    }

    private static void validateKeySize(int keySize) {
        if (keySize != 112 && keySize != 168 && keySize != 128 && keySize != 192) {
            throw new IllegalKeyException("DESEDE key must be of length 128 or 192 bits including parity");
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm algorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        TripleDES.validateKeySize(vKey.getKeySizeInBits());
        Utils.checkKeyAlgorithm(vKey, FipsTripleDES.ALGORITHM, algorithm);
        return vKey;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<Parameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean forWrapping, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardWrapper(forWrapping, TripleDES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), parameters, random);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardMac(TripleDES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (GeneralAuthParameters)parameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return Utils.bitsToBytes(parameters.macLenInBits);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardAEADCipher(forEncryption, TripleDES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (AuthenticationParametersWithIV)parameters);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardCipher(forEncryption, TripleDES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (ParametersWithIV)parameters, random);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final FipsTripleDES.KeyGenerator keyGen;

        public KeyGenerator(GeneralParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this.algorithm = (GeneralAlgorithm)parameterSet.getAlgorithm();
            this.keyGen = new FipsTripleDES.KeyGenerator(keySizeInBits, random);
        }

        @Override
        public SymmetricKey doGenerateKey() {
            return new SymmetricSecretKey(this.algorithm, this.keyGen.generateKey().getKeyBytes());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm, 8, iv, macLenInBits);
        }

        public AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 64));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, iv, macSizeInBits);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm, 8, algorithm.checkIv(iv, 8));
        }

        public Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm algorithm, byte[] iv) {
            return new Parameters(algorithm, iv);
        }
    }
}

