/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.Key;
import org.bouncycastle.crypto.KeyUnwrapper;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.KeyWrapper;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.Wrapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class GuardedKeyWrapOperatorFactory<T extends Parameters, K extends Key>
implements KeyWrapOperatorFactory<T, K> {
    GuardedKeyWrapOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public KeyWrapper<T> createKeyWrapper(K key, T parameters) {
        return new GuardedWrapper(this, key, parameters, null);
    }

    @Override
    public KeyUnwrapper<T> createKeyUnwrapper(K key, T parameters) {
        return new GuardedUnwrapper(this, parameters.getAlgorithm(), parameters, this.createWrapper(false, key, parameters, null));
    }

    protected abstract Wrapper createWrapper(boolean var1, K var2, T var3, SecureRandom var4);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GuardedUnwrapper
    implements KeyUnwrapper<T> {
        private final Algorithm algorithm;
        private final T parameters;
        private final Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedUnwrapper(Algorithm algorithm, T parameters, Wrapper wrapper) {
            this.this$0 = var1_1;
            this.algorithm = algorithm;
            this.parameters = parameters;
            this.wrapper = wrapper;
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
            Utils.approveModeCheck(this.algorithm);
            try {
                return this.wrapper.unwrap(in, inOff, inLen);
            }
            catch (Exception e) {
                throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GuardedWrapper
    implements KeyWrapperUsingSecureRandom<T> {
        private final Algorithm algorithm;
        private final K key;
        private final T parameters;
        private final SecureRandom random;
        private Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedWrapper(K key, T parameters, SecureRandom random) {
            this.this$0 = var1_1;
            this.algorithm = parameters.getAlgorithm();
            this.key = key;
            this.parameters = parameters;
            this.random = random;
        }

        void setUp() {
            if (this.wrapper == null) {
                this.wrapper = this.this$0.createWrapper(true, this.key, this.parameters, this.random);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] wrap(byte[] in, int inOff, int inLen) {
            Utils.approveModeCheck(this.algorithm);
            this.setUp();
            return this.wrapper.wrap(in, inOff, inLen);
        }

        @Override
        public KeyWrapperUsingSecureRandom<T> withSecureRandom(SecureRandom random) {
            return new GuardedWrapper(this.this$0, this.key, this.parameters, random);
        }
    }
}

