/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricOperatorFactory;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SingleBlockEncryptorUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class GuardedAsymmetricOperatorFactory<T extends Parameters>
implements AsymmetricOperatorFactory<T> {
    GuardedAsymmetricOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public SingleBlockEncryptorUsingSecureRandom<T> createBlockEncryptor(AsymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", parameters.getAlgorithm());
        }
        return new BlockEncryptor(this, key, parameters, null);
    }

    protected abstract AsymmetricBlockCipher createCipher(boolean var1, AsymmetricKey var2, T var3, SecureRandom var4);

    protected static boolean isRawEngine(AsymmetricBlockCipher engine) {
        return !(engine instanceof PKCS1Encoding) && !(engine instanceof OAEPEncoding);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BlockEncryptor
    implements SingleBlockEncryptorUsingSecureRandom<T> {
        private final AsymmetricKey key;
        private final T parameters;
        private final SecureRandom random;
        private AsymmetricBlockCipher engine;
        final /* synthetic */ GuardedAsymmetricOperatorFactory this$0;

        BlockEncryptor(AsymmetricKey key, T parameters, SecureRandom random) {
            this.this$0 = var1_1;
            this.key = key;
            this.parameters = parameters;
            this.random = random;
        }

        private AsymmetricBlockCipher getEngine() {
            if (this.engine == null) {
                this.engine = this.this$0.createCipher(true, this.key, this.parameters, this.random);
            }
            return this.engine;
        }

        @Override
        public byte[] encryptBlock(byte[] bytes, int offSet, int length) throws PlainInputProcessingException {
            try {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                return this.getEngine().processBlock(bytes, offSet, length);
            }
            catch (Exception e) {
                throw new PlainInputProcessingException("Unable to encrypt block: " + e.getMessage(), e);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getInputSize() {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            AsymmetricBlockCipher engine = this.getEngine();
            if (GuardedAsymmetricOperatorFactory.isRawEngine(engine)) {
                return engine.getInputBlockSize() + 1;
            }
            return engine.getInputBlockSize();
        }

        @Override
        public int getOutputSize() {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            return this.getEngine().getOutputBlockSize();
        }

        @Override
        public SingleBlockEncryptorUsingSecureRandom<T> withSecureRandom(SecureRandom random) {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            return new BlockEncryptor(this.this$0, this.key, this.parameters, random);
        }
    }
}

